<?php
    $keypath = getkeypath();
    //获取私钥文件
    $private_key = getprivate_key();
    //获取公钥文件
    $public_key = getpublic_key();

    function getpublic_key(){
        global $keypath;
        $verifyKey4Server = file_get_contents(rtrim($keypath['public_path']));//读取AES文件到字符串中
        $pem = chunk_split(base64_encode($verifyKey4Server),64,"\n");//转换为pem格式的公钥
        $public_key = "-----BEGIN CERTIFICATE-----\n".$pem."-----END CERTIFICATE-----\n";
        return $public_key;
    }

    function getprivate_key(){
        global $keypath;
        $pubKey = file_get_contents(rtrim($keypath['privatekey_path']));
        $results=array();
        $worked=openssl_pkcs12_read($pubKey,$results,rtrim($keypath['privatekey_pass']));
        $private_key=$results['pkey'];
        return $private_key;
    }

    function getkeypath(){
        $fp=fopen('encrypt/config.ini','r');
        $keypath = array();
        while(!feof($fp)){
            $line=fgets($fp);
            $arr=explode('=',$line);
            if(!strcmp($arr[0],"privatekey_path")){
                $keypath["privatekey_path"] = $arr[1];
            }
            if(!strcmp($arr[0],"privatekey_pass")){
                $keypath["privatekey_pass"] = $arr[1];
            }
            if(!strcmp($arr[0],"public_path")){
                $keypath["public_path"] = $arr[1];
            }
        }
        fclose($fp);
        return $keypath;
    }
    function setzero($var){
        $data = array_filter($var, function($value) {
            // 检查值是否为null、空字符串、空数组、未设置的变量、或者是特殊的空值表示
            return $value !== null && $value !== "" && $value !== [] && $value !== false && $value !== "\0";
        });
        ksort($data);
        return $data;
    }
    //将空值去除，0不为空值
    function getdata($json_arr){
        foreach($json_arr as $k=>$var){
            if(is_scalar($var) && $var !== '' && $var !== null){//如果给出的变量参数 var 是一个标量，is_scalar() 返回 TRUE，否则返回 FALSE。标量变量是指那些包含了 integer、float、string 或 boolean的变量，而 array、object 和 resource 则不是标量。
                $data[$k] = $var;
            }else if(is_object($var)){
                $data[$k] = setzero($var);
            }else if(is_array($var)){
                $data[$k] = setzero($var);
            }
            if(is_scalar($var)){
                unset($var);
            }
        }
        ksort($data);
        return $data;
    }
    function getSorting2($data){
        $hmacSource = '';
        foreach($data as $key => $value){
            if(is_object($value)){
                $value = getSorting2($value);
                $hmacSource .= trim($value);
            }else if(is_array($value)){
                ksort($value);
                $value = getSorting2($value);
                $hmacSource .= trim($value);
            }else{
                $value .= '#';
                $hmacSource .= trim($value);
            }
        }
        return $hmacSource;
    }
    //数据排序
    function getSorting($data){
        $hmacSource = '';
        foreach($data as $key => $value){
            if(is_array($value)){
                ksort($value);
                foreach($value as $key2 => $value2) {
                    if(is_object($value2)) {
                        $value2 = array_filter((array)$value2);
                        ksort($value2);
                        foreach ($value2 as $oKey => $value3) {   
                            if(is_object($value3)){
                                $value3 = array_filter((array)$value3);
                                ksort($value3);
                                foreach ($value3 as $oKey => $oValue) {
                                    $oValue .= '#';
                                    $hmacSource .= trim($oValue);
                                }
                            }else if(is_array($value3)){
                                ksort($value3);
                                foreach($value3 as $key4 => $value4) {
                                    if(is_object($value4)) {
                                        $value4 = array_filter((array)$value4);
                                        ksort($value4);
                                        foreach ($value4 as $oKey => $oValue) {
                                            $oValue .= '#';
                                            $hmacSource .= trim($oValue);
                                        }
                                    }else{
                                        $value4 .= '#';
                                        $hmacSource .= trim($value4);
                                    }
                                }
                            }else{
                                $value3 .= '#';
                                $hmacSource .= trim($value3);
                            }
                        }
                    }else if(is_array($value2)){
                        ksort($value2);
                        foreach($value2 as $key3 => $value3) {    
                            if(is_object($value3)) {
                                $value3 = array_filter((array)$value3);
                                ksort($value3);
                                foreach ($value3 as $oKey => $oValue) {
                                    $oValue .= '#';
                                    $hmacSource .= trim($oValue);
                                }
                            }else if(is_array($value3)){
                                ksort($value3);
                                foreach($value3 as $key4 => $value4) {
                                    if(is_object($value4)) {
                                        $value4 = array_filter((array)$value4);
                                        ksort($value4);
                                        foreach ($value4 as $oKey => $oValue) {
                                            $oValue .= '#';
                                            $hmacSource .= trim($oValue);
                                        }
                                    }else{
                                        $value4 .= '#';
                                        $hmacSource .= trim($value4);
                                    }
                                }
                            }else{
                                $value3 .= '#';
                                $hmacSource .= trim($value3);
                            }
                        }
                    }else{
                        $value2 .= '#';
                        $hmacSource .= trim($value2);
                    }
                }
            }else{
                $value .= '#';
                $hmacSource .= trim($value);
            }
        }
        return $hmacSource;
    }
    //数据签名返回hmac
    function getDataMac($hmacSource){
        //sha1签名
        $sha1mac=sha1($hmacSource,true);
        //私钥签名
        global $private_key;
        $rs=openssl_sign($sha1mac,$hmac,$private_key,OPENSSL_ALGO_MD5);
        $hmac=base64_encode($hmac);
        return $hmac;
    }
    //将hmac参数添加进请求参数后，将请求参数转为JSON
    function mergeData($hmac,$json_arr){
        $hmacarr=array();
        $hmacarr["hmac"]=$hmac;
        $arr_t=(array_merge($json_arr,$hmacarr));
        //将数组转成JSON
        $json_str=json_encode($arr_t,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        return $json_str;
    }
    //生成AES密钥
    function getAESkey(){
        $str1='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
        $randStr = str_shuffle($str1);//打乱字符串
        $rands= substr($randStr,0,16);
        return $rands;
    }
    //通过AES密钥将请求参数加密
    function getCurlData($rands,$json_str){
        $screct_key = $rands;
        $str = trim($json_str);
        $str = addPKCS7Padding($str);
        $encrypt_str= openssl_encrypt($str, 'AES-128-ECB', $screct_key, OPENSSL_RAW_DATA|OPENSSL_ZERO_PADDING);
        $data = base64_encode($encrypt_str);
        return $data;
    }
    //填充算法
    function addPKCS7Padding($string, $blocksize = 16) {
        $len = strlen($string);
        $pad = $blocksize - ($len % $blocksize);
        $string .= str_repeat(chr($pad), $pad);
        return $string;
    }
    //通过公钥加密AES密钥生成encryptkey
    function getEncryptKey($rands){
        global $public_key;
        $pu_key =  openssl_pkey_get_public($public_key);//这个函数可用来判断公钥是否是可用的
        openssl_public_encrypt($rands,$encryptKey,$pu_key);//公钥加密
        $encryptKey = base64_encode($encryptKey);
        return $encryptKey;
    }
    //请求接口并接收返回值
    function postInterface($url,$encryptKey,$data,$merchantId,$requestId,$partnerId){
        $curl = curl_init($url);
        curl_setopt($curl,CURLOPT_HEADER, 1 ); // 过滤HTTP头
        curl_setopt($curl,CURLOPT_HTTPHEADER,array(
            'Content-Type: application/vnd.geoswift-v3.0+json',
            'encryptKey: '.$encryptKey,
            'merchantId: '.$merchantId,
            'partnerId: '.$partnerId,
            'requestId: '.$requestId
        ));
        curl_setopt($curl,CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
        curl_setopt($curl,CURLOPT_POST,true); // post传输数据
        curl_setopt($curl,CURLOPT_POSTFIELDS,$data);// post传输数据
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);//SSL证书认证
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);//严格认证

        //获取返回数据
        $responseText = curl_exec($curl);
        return $responseText;
    }
    //通过正则获取返回参数data,encryptkey,merchantid
    function getresponsedata($responseText){
        preg_match_all('/(encryptKey|merchantId|data"):(\s+|")([^"\s]+)/si',$responseText,$m);
        list($encryptkey, $merchantid, $data) = $m[3];
        $responsedata = array("data" =>$data,"encryptkey"=>$encryptkey,"merchantid"=>$merchantid);
        return $responsedata;
    }
    //私钥解密encryptkey，获取到接口返回的AESKEY
    function getDecryptAESKey($encryptkey){
        global $private_key;
        $pi_key =  openssl_pkey_get_private($private_key);//这个函数可用来判断私钥是否是可用的，可用返回资源id Resource id
        openssl_private_decrypt(base64_decode($encryptkey),$decrypted,$pi_key);//私钥解密
        $screct_key = $decrypted;
        return $screct_key;
    }
    //通过AESKEY解密返回的DATA，并将为空的参数去除
    function AESDecryptData($responsedatadata,$screct_key){
        $encrypt_str=  openssl_decrypt($responsedatadata,"AES-128-ECB",$screct_key);
        $encrypt_str = preg_replace('/[\x00-\x1F]/','', $encrypt_str);
        $encrypt_str = json_decode($encrypt_str,true);
        function clearBlank($arr){
            function  filter_function($arr){
                if($arr === '' || $arr === null){
                    return false;
                }
                return true;
            }
            return array_filter($arr,'filter_function');
        }

        function array_remove_empty(& $arr, $trim = true){
            foreach ($arr as $key => $value) {
                if (is_array($value)) {
                    array_remove_empty($arr[$key]);
                } else {
                    $value = trim($value);
                    if ($value == '') {
                        unset($arr[$key]);
                    } elseif ($trim) {
                        $arr[$key] = $value;
                    }
                }
            }
        }
        $encrypt_str = clearBlank($encrypt_str);
        return $encrypt_str;
    }
    //通过公钥进行验签
    function dataVerify($hmacSource2,$hmac){
        $sha1mac2=sha1($hmacSource2,true);

        global $public_key;
        $keyid = openssl_pkey_get_public($public_key);
        $verify = openssl_verify($sha1mac2,base64_decode($hmac),$keyid,OPENSSL_ALGO_MD5);
        return $verify;
    }

