package com.ehking.demo.sample;

import com.alibaba.fastjson.JSONObject;
import com.ehking.demo.config.CustomConfig;
import com.ehking.demo.utils.JsonBuilder;
import com.ehking.demo.utils.MyExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * 功能描述:
 * 轻量级sdk接口调用示例
 */
public class ApiRequestDemo {
    static final Logger LOGGER = LoggerFactory.getLogger(ApiRequestDemo.class);

    static public void query() {
        String merchantId = "G90008001";
        String partnerId = null;

        //api接口地址
        String apiUrl = "https://qa-api.geoswift.com/fx/order/query";
        //接口请求原始数据
        String rawJsonData = "{\"merchantId\": \"G90008001\",\"requestId\": \"17604208083341\"}";
        JSONObject rawDataJson = JSONObject.parseObject(rawJsonData);

        LOGGER.info("接口地址：{}", apiUrl);
        LOGGER.info("请求报文json: {}: ", rawDataJson.toJSONString());

        //对原始请求数据进行数据签名、加密处理
        JsonBuilder jsonSupport = new JsonBuilder(merchantId, partnerId, rawDataJson);

        MyExecuter myExecuter = new MyExecuter();
        //请求接口，对同步返回的应答报文进行解密、验签，返回解密后的报文
        JSONObject rawRespJsonData = myExecuter.ApiRequest(jsonSupport, apiUrl);

        LOGGER.info("应答报文json: {}: ", rawRespJsonData.toJSONString());
    }


    static public void main(String[] args) {
        CustomConfig customConfig = new CustomConfig();
        try {
            customConfig.loadSdkConfig();
        } catch (Exception e) {
            e.printStackTrace();
        }

        ApiRequestDemo.query();


    }
}
