package com.ehking.demo.fx;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.exception.HmacVerifyException;
import com.ehking.sdk.exception.RequestException;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.ResultListenerAdpater;
import com.ehking.sdk.fx.builder.FxOrderCreateBuilder;
import com.ehking.sdk.fx.executor.FxOrderExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class FxOrderServlet extends HttpServlet {
    static final Logger LOGGER = LoggerFactory.getLogger(FxOrderServlet.class);
    private static final long serialVersionUID = -7375754974773299360L;


    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }

    @Override
    protected void doPost(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {

        request.setCharacterEncoding("UTF-8");
        final PrintWriter out = resp.getWriter();

        FxOrderCreateBuilder builder = new FxOrderCreateBuilder()
                .setPartnerId(request.getParameter("partnerId"))
                .setMerchantId(request.getParameter("merchantId"))
                .setRequestId(request.getParameter("requestId"))
                .setToken(request.getParameter("token"))
                .setNotifyUrl(request.getParameter("notifyUrl"));

        try {
            FxOrderExecutor executor = new FxOrderExecutor();
            // 创建报价单
            executor.createOrder(builder, new ResultListenerAdpater() {

                @Override
                public void success(JSONObject jsonObject) {
                    LOGGER.debug("success jsonObject:[" + jsonObject + "]");
                    request.getSession().setAttribute("json", jsonObject.toJSONString());
                    out.println("提交成功</br>");
                    out.println(jsonObject);
                }

                @Override
                public void failure(JSONObject jsonObject) {
                    LOGGER.debug("failure jsonObject:[" + jsonObject + "]");
                    request.getSession().setAttribute("json", jsonObject.toJSONString());
                    out.println("提交失败</br>");
                    out.println(jsonObject);
                }

                @Override
                public void processing(JSONObject jsonObject) {
                    LOGGER.debug("processing jsonObject:[" + jsonObject + "]");
                    request.getSession().setAttribute("json", jsonObject.toJSONString());
                    out.println("提交处理中</br>");
                    out.println(jsonObject);
                }
            });
        } catch (ResponseException e) {
            out.println("响应异常</br>");
            out.println(e);
        } catch (HmacVerifyException e) {
            out.println("签名验证异常</br>");
            out.println(e);
        } catch (RequestException e) {
            out.println("请求异常</br>");
            out.println(e);
        } catch (UnknownException e) {
            out.println("未知异常</br>");
            out.println(e);
        }
    }
}
