package com.ehking.demo.config;

import com.ehking.sdk.ConfigurationUtils;
import org.apache.commons.configuration.MapConfiguration;

import java.util.HashMap;
import java.util.Map;

/**
 * 功能描述:
 * 不使用配置文件，注入配置示例
 * 当商户系统的配置文件没有部署在本地，如在nacos中或数据库中，可通过此示例方法，把远程的配置信息注入到sdk中
 */
public class CustomConfig {
    public void loadSdkConfig() throws Exception {
        // 从配置文件或其他来源加载配置
        System.out.println("SDK配置注入开始...");
        Map<String, String> sdkConfig = initConfig();
        // 注入配置到 SDK
        ConfigurationUtils.setConfigSource(new MapConfiguration(sdkConfig));
        // 设置系统属性
        System.setProperty("jdk.tls.disabledAlgorithms", "");
        // 可选择添加日志记录
        System.out.println("SDK配置注入完成.");
    }

    private Map<String, String> initConfig() {

        Map<String, String> configMap = new HashMap<>();
        // HTTP 配置
        configMap.put("http.content.type.v3", "application/vnd.geoswift-v3.0+json");
        configMap.put("ehking.sdk.net.client.defaultConnectTimeout", "30000");
        configMap.put("ehking.sdk.net.client.defaultReadTimeout", "30000");

        //API 接口地址
        configMap.put("fx.create.quotation.url","https://qa-api.geoswift.com/fx/quotation/quote");
        configMap.put("fx.create.order.url","https://qa-api.geoswift.com/fx/order/create");
        configMap.put("fx.query.order.url","https://qa-api.geoswift.com/fx/order/query");

        //Geoswift生产环境公钥，不要更换
        configMap.put("server.public.key.path", "/Users/Shared/export/cert/platform_public.cer");

        //测试商户证书，商户上线时需要更换成自己的实际证书
        configMap.put("G90008001.client.private.key.path", "/Users/Shared/export/cert/client.pfx");
        configMap.put("G90008001.client.private.key.password", "123456");


        return configMap;
    }

    public static void main(String[] args) {
        CustomConfig customConfig = new CustomConfig();
        try {
            customConfig.loadSdkConfig();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}