/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.math.ec;

import java.math.BigInteger;
import org.bouncycastle.by_1_52.math.ec.ECAlgorithms;
import org.bouncycastle.by_1_52.math.ec.ECMultiplier;
import org.bouncycastle.by_1_52.math.ec.ECPoint;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    @Override
    public ECPoint multiply(ECPoint p, BigInteger k) {
        int sign = k.signum();
        if (sign == 0 || p.isInfinity()) {
            return p.getCurve().getInfinity();
        }
        ECPoint positive = this.multiplyPositive(p, k.abs());
        ECPoint result = sign > 0 ? positive : positive.negate();
        return ECAlgorithms.validatePoint(result);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);
}

