/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.by_1_52.crypto.tls.AbstractTlsClient;
import org.bouncycastle.by_1_52.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle.by_1_52.crypto.tls.DefaultTlsSRPGroupVerifier;
import org.bouncycastle.by_1_52.crypto.tls.TlsAuthentication;
import org.bouncycastle.by_1_52.crypto.tls.TlsCipher;
import org.bouncycastle.by_1_52.crypto.tls.TlsCipherFactory;
import org.bouncycastle.by_1_52.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.by_1_52.crypto.tls.TlsFatalAlert;
import org.bouncycastle.by_1_52.crypto.tls.TlsKeyExchange;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPGroupVerifier;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPKeyExchange;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPUtils;
import org.bouncycastle.by_1_52.crypto.tls.TlsUtils;
import org.bouncycastle.by_1_52.util.Arrays;

public class SRPTlsClient
extends AbstractTlsClient {
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] identity, byte[] password) {
        this(new DefaultTlsCipherFactory(), new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, byte[] identity, byte[] password) {
        this(cipherFactory, new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, TlsSRPGroupVerifier groupVerifier, byte[] identity, byte[] password) {
        super(cipherFactory);
        this.groupVerifier = groupVerifier;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(clientExtensions, this.identity);
        return clientExtensions;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(serverExtensions);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.groupVerifier, this.identity, this.password);
    }
}

