/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.by_1_52.crypto.tls.Certificate;
import org.bouncycastle.by_1_52.crypto.tls.ProtocolVersion;
import org.bouncycastle.by_1_52.crypto.tls.TlsContext;
import org.bouncycastle.by_1_52.crypto.tls.TlsCredentials;
import org.bouncycastle.by_1_52.crypto.tls.TlsFatalAlert;
import org.bouncycastle.by_1_52.crypto.tls.TlsKeyExchange;
import org.bouncycastle.by_1_52.crypto.tls.TlsUtils;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected Vector supportedSignatureAlgorithms;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms) {
        this.keyExchange = keyExchange;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
    }

    @Override
    public void init(TlsContext context) {
        block8: {
            ProtocolVersion clientVersion;
            block7: {
                this.context = context;
                clientVersion = context.getClientVersion();
                if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) break block7;
                if (this.supportedSignatureAlgorithms != null) break block8;
                switch (this.keyExchange) {
                    case 3: 
                    case 7: 
                    case 22: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultDSSSignatureAlgorithms();
                        break block8;
                    }
                    case 16: 
                    case 17: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultECDSASignatureAlgorithms();
                        break block8;
                    }
                    case 1: 
                    case 5: 
                    case 9: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 23: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultRSASignatureAlgorithms();
                        break block8;
                    }
                    case 13: 
                    case 14: 
                    case 21: 
                    case 24: {
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException("unsupported key exchange algorithm");
                    }
                }
            }
            if (this.supportedSignatureAlgorithms != null) {
                throw new IllegalStateException("supported_signature_algorithms not allowed for " + clientVersion);
            }
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.supportedSignatureAlgorithms == null) {
            // empty if block
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.processServerCertificate(serverCredentials.getCertificate());
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }
}

