/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.macs;

import org.bouncycastle.by_1_52.crypto.CipherParameters;
import org.bouncycastle.by_1_52.crypto.Digest;
import org.bouncycastle.by_1_52.crypto.Mac;
import org.bouncycastle.by_1_52.crypto.params.KeyParameter;

public class OldHMac
implements Mac {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private Digest digest;
    private int digestSize;
    private byte[] inputPad = new byte[64];
    private byte[] outputPad = new byte[64];

    public OldHMac(Digest digest) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters params) {
        int i;
        this.digest.reset();
        byte[] key = ((KeyParameter)params).getKey();
        if (key.length > 64) {
            this.digest.update(key, 0, key.length);
            this.digest.doFinal(this.inputPad, 0);
            for (i = this.digestSize; i < this.inputPad.length; ++i) {
                this.inputPad[i] = 0;
            }
        } else {
            System.arraycopy(key, 0, this.inputPad, 0, key.length);
            for (i = key.length; i < this.inputPad.length; ++i) {
                this.inputPad[i] = 0;
            }
        }
        this.outputPad = new byte[this.inputPad.length];
        System.arraycopy(this.inputPad, 0, this.outputPad, 0, this.inputPad.length);
        i = 0;
        while (i < this.inputPad.length) {
            int n = i++;
            this.inputPad[n] = (byte)(this.inputPad[n] ^ 0x36);
        }
        i = 0;
        while (i < this.outputPad.length) {
            int n = i++;
            this.outputPad[n] = (byte)(this.outputPad[n] ^ 0x5C);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digestSize];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.outputPad, 0, this.outputPad.length);
        this.digest.update(tmp, 0, tmp.length);
        int len = this.digest.doFinal(out, outOff);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

