/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.by_1_52.crypto.KeyGenerationParameters;
import org.bouncycastle.by_1_52.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle.by_1_52.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.by_1_52.crypto.params.DHParameters;
import org.bouncycastle.by_1_52.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

