/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.va.builder.VaAccountCreateBuilder;
import com.ehking.sdk.va.builder.VaAccountDeleteBuilder;
import com.ehking.sdk.va.builder.VaAccountQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaAccountExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(VaAccountExecutor.class);

    public void createAccount(VaAccountCreateBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("va createAccount requestData:[{}]", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getVaCreateAccountUrl(), requestData);
            LOGGER.info("va createAccount responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("va createAccount error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("va createAccount error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void queryAccount(VaAccountQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("va queryAccount requestData:[{}]", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getVaQueryAccountUrl(), requestData);
            LOGGER.info("va queryAccount responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("va queryAccount error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("va queryAccount error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void deleteAccount(VaAccountDeleteBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("va deleteAccount requestData:[{}]", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getVaDeleteAccountUrl(), requestData);
            LOGGER.info("va deleteAccount responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("va deleteAccount error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("va deleteAccount error", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void notify(JSONObject responseData, ResultListener listener) {
        LOGGER.info("va account notify responseData: {}", (Object)responseData);
        this.decryptCallback(responseData, listener);
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        LOGGER.info("va account decryptCallback: {}", (Object)responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else if (Constants.PROCESSING.equals(status)) {
            listener.pending(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

