/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.va.builder.UploadFeeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ProfileExecutor.class);

    public void bothUploadFee(UploadFeeBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("ProfileExecutor bothUploadFee requestData:[" + requestData.toJSONString() + "],orderUrl:[" + ConfigurationUtils.getRemittanceOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getVaUploadFeeUrl(), requestData);
        LOGGER.debug("ProfileExecutor bothUploadFee responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("ProfileExecutor bothUploadFee responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            if (Constants.SUCCESS.equals(responseData.getString("businessStatus"))) {
                resultListener.success(responseData);
            } else if (Constants.FAILED.equals(responseData.getString("businessStatus"))) {
                resultListener.failure(responseData);
            }
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

