/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class VaAccountCreateBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String partnerId;
    private String accountName;
    private String accountShortName;
    private String registryCountry;
    private String currency;
    private String forUse;
    private String notifyUrl;
    private String subCategory;
    private String bvn;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaAccountCreateBuilder)) {
            return false;
        }
        VaAccountCreateBuilder other = (VaAccountCreateBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$accountShortName = this.getAccountShortName();
        String other$accountShortName = other.getAccountShortName();
        if (this$accountShortName == null ? other$accountShortName != null : !this$accountShortName.equals(other$accountShortName)) {
            return false;
        }
        String this$registryCountry = this.getRegistryCountry();
        String other$registryCountry = other.getRegistryCountry();
        if (this$registryCountry == null ? other$registryCountry != null : !this$registryCountry.equals(other$registryCountry)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$forUse = this.getForUse();
        String other$forUse = other.getForUse();
        if (this$forUse == null ? other$forUse != null : !this$forUse.equals(other$forUse)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$bvn = this.getBvn();
        String other$bvn = other.getBvn();
        return !(this$bvn == null ? other$bvn != null : !this$bvn.equals(other$bvn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaAccountCreateBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $accountShortName = this.getAccountShortName();
        result = result * 59 + ($accountShortName == null ? 43 : $accountShortName.hashCode());
        String $registryCountry = this.getRegistryCountry();
        result = result * 59 + ($registryCountry == null ? 43 : $registryCountry.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $forUse = this.getForUse();
        result = result * 59 + ($forUse == null ? 43 : $forUse.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $bvn = this.getBvn();
        result = result * 59 + ($bvn == null ? 43 : $bvn.hashCode());
        return result;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountShortName() {
        return this.accountShortName;
    }

    public String getRegistryCountry() {
        return this.registryCountry;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getForUse() {
        return this.forUse;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getBvn() {
        return this.bvn;
    }

    public VaAccountCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public VaAccountCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public VaAccountCreateBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public VaAccountCreateBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public VaAccountCreateBuilder setAccountShortName(String accountShortName) {
        this.accountShortName = accountShortName;
        return this;
    }

    public VaAccountCreateBuilder setRegistryCountry(String registryCountry) {
        this.registryCountry = registryCountry;
        return this;
    }

    public VaAccountCreateBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public VaAccountCreateBuilder setForUse(String forUse) {
        this.forUse = forUse;
        return this;
    }

    public VaAccountCreateBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public VaAccountCreateBuilder setSubCategory(String subCategory) {
        this.subCategory = subCategory;
        return this;
    }

    public VaAccountCreateBuilder setBvn(String bvn) {
        this.bvn = bvn;
        return this;
    }

    public String toString() {
        return "VaAccountCreateBuilder(merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ", partnerId=" + this.getPartnerId() + ", accountName=" + this.getAccountName() + ", accountShortName=" + this.getAccountShortName() + ", registryCountry=" + this.getRegistryCountry() + ", currency=" + this.getCurrency() + ", forUse=" + this.getForUse() + ", notifyUrl=" + this.getNotifyUrl() + ", subCategory=" + this.getSubCategory() + ", bvn=" + this.getBvn() + ")";
    }
}

