/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;

public class UploadFeeBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private Long openFee;
    private Long fee;
    private Long hkMinimumFee;
    private Long usaMinimumFee;
    private Long usaMinimumFeeLocal;
    private Long usaTtFee;
    private Long usaAchFee;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public UploadFeeBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public UploadFeeBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Long getOpenFee() {
        return this.openFee;
    }

    public void setOpenFee(Long openFee) {
        this.openFee = openFee;
    }

    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getHkMinimumFee() {
        return this.hkMinimumFee;
    }

    public void setHkMinimumFee(Long hkMinimumFee) {
        this.hkMinimumFee = hkMinimumFee;
    }

    public Long getUsaMinimumFee() {
        return this.usaMinimumFee;
    }

    public void setUsaMinimumFee(Long usaMinimumFee) {
        this.usaMinimumFee = usaMinimumFee;
    }

    public Long getUsaMinimumFeeLocal() {
        return this.usaMinimumFeeLocal;
    }

    public void setUsaMinimumFeeLocal(Long usaMinimumFeeLocal) {
        this.usaMinimumFeeLocal = usaMinimumFeeLocal;
    }

    public Long getUsaTtFee() {
        return this.usaTtFee;
    }

    public void setUsaTtFee(Long usaTtFee) {
        this.usaTtFee = usaTtFee;
    }

    public Long getUsaAchFee() {
        return this.usaAchFee;
    }

    public void setUsaAchFee(Long usaAchFee) {
        this.usaAchFee = usaAchFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadFeeBuilder)) {
            return false;
        }
        UploadFeeBuilder other = (UploadFeeBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Long this$openFee = this.getOpenFee();
        Long other$openFee = other.getOpenFee();
        if (this$openFee == null ? other$openFee != null : !((Object)this$openFee).equals(other$openFee)) {
            return false;
        }
        Long this$fee = this.getFee();
        Long other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        Long this$hkMinimumFee = this.getHkMinimumFee();
        Long other$hkMinimumFee = other.getHkMinimumFee();
        if (this$hkMinimumFee == null ? other$hkMinimumFee != null : !((Object)this$hkMinimumFee).equals(other$hkMinimumFee)) {
            return false;
        }
        Long this$usaMinimumFee = this.getUsaMinimumFee();
        Long other$usaMinimumFee = other.getUsaMinimumFee();
        if (this$usaMinimumFee == null ? other$usaMinimumFee != null : !((Object)this$usaMinimumFee).equals(other$usaMinimumFee)) {
            return false;
        }
        Long this$usaMinimumFeeLocal = this.getUsaMinimumFeeLocal();
        Long other$usaMinimumFeeLocal = other.getUsaMinimumFeeLocal();
        if (this$usaMinimumFeeLocal == null ? other$usaMinimumFeeLocal != null : !((Object)this$usaMinimumFeeLocal).equals(other$usaMinimumFeeLocal)) {
            return false;
        }
        Long this$usaTtFee = this.getUsaTtFee();
        Long other$usaTtFee = other.getUsaTtFee();
        if (this$usaTtFee == null ? other$usaTtFee != null : !((Object)this$usaTtFee).equals(other$usaTtFee)) {
            return false;
        }
        Long this$usaAchFee = this.getUsaAchFee();
        Long other$usaAchFee = other.getUsaAchFee();
        return !(this$usaAchFee == null ? other$usaAchFee != null : !((Object)this$usaAchFee).equals(other$usaAchFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadFeeBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Long $openFee = this.getOpenFee();
        result = result * 59 + ($openFee == null ? 43 : ((Object)$openFee).hashCode());
        Long $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        Long $hkMinimumFee = this.getHkMinimumFee();
        result = result * 59 + ($hkMinimumFee == null ? 43 : ((Object)$hkMinimumFee).hashCode());
        Long $usaMinimumFee = this.getUsaMinimumFee();
        result = result * 59 + ($usaMinimumFee == null ? 43 : ((Object)$usaMinimumFee).hashCode());
        Long $usaMinimumFeeLocal = this.getUsaMinimumFeeLocal();
        result = result * 59 + ($usaMinimumFeeLocal == null ? 43 : ((Object)$usaMinimumFeeLocal).hashCode());
        Long $usaTtFee = this.getUsaTtFee();
        result = result * 59 + ($usaTtFee == null ? 43 : ((Object)$usaTtFee).hashCode());
        Long $usaAchFee = this.getUsaAchFee();
        result = result * 59 + ($usaAchFee == null ? 43 : ((Object)$usaAchFee).hashCode());
        return result;
    }

    public String toString() {
        return "UploadFeeBuilder(merchantId=" + this.getMerchantId() + ", partnerId=" + this.getPartnerId() + ", requestId=" + this.getRequestId() + ", openFee=" + this.getOpenFee() + ", fee=" + this.getFee() + ", hkMinimumFee=" + this.getHkMinimumFee() + ", usaMinimumFee=" + this.getUsaMinimumFee() + ", usaMinimumFeeLocal=" + this.getUsaMinimumFeeLocal() + ", usaTtFee=" + this.getUsaTtFee() + ", usaAchFee=" + this.getUsaAchFee() + ")";
    }
}

