/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import java.util.List;

public class OrderProofBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String id;
    private String otherProof;
    private List<String> proofList;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public OrderProofBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public OrderProofBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getProofList() {
        return this.proofList;
    }

    public void setProofList(List<String> proofList) {
        this.proofList = proofList;
    }

    public String getOtherProof() {
        return this.otherProof;
    }

    public void setOtherProof(String otherProof) {
        this.otherProof = otherProof;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderProofBuilder)) {
            return false;
        }
        OrderProofBuilder other = (OrderProofBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$otherProof = this.getOtherProof();
        String other$otherProof = other.getOtherProof();
        if (this$otherProof == null ? other$otherProof != null : !this$otherProof.equals(other$otherProof)) {
            return false;
        }
        List<String> this$proofList = this.getProofList();
        List<String> other$proofList = other.getProofList();
        return !(this$proofList == null ? other$proofList != null : !((Object)this$proofList).equals(other$proofList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderProofBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $otherProof = this.getOtherProof();
        result = result * 59 + ($otherProof == null ? 43 : $otherProof.hashCode());
        List<String> $proofList = this.getProofList();
        result = result * 59 + ($proofList == null ? 43 : ((Object)$proofList).hashCode());
        return result;
    }

    public String toString() {
        return "OrderProofBuilder(merchantId=" + this.getMerchantId() + ", partnerId=" + this.getPartnerId() + ", id=" + this.getId() + ", otherProof=" + this.getOtherProof() + ", proofList=" + this.getProofList() + ")";
    }
}

