/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;

public class DeclarationQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;

    public DeclarationQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public DeclarationQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

