/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.va.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.va.builder.DeclarationAuthorizedBuilder;
import com.ehking.sdk.va.builder.DeclarationBeneficialBuilder;
import com.ehking.sdk.va.builder.DeclarationBusinessBuilder;
import com.ehking.sdk.va.builder.DeclarationCertificateBuilder;
import com.ehking.sdk.va.builder.DeclarationCompanyBuilder;
import com.ehking.sdk.va.builder.DeclarationLegalBuilder;
import java.util.List;

public class DeclarationBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String subMerchantId;
    private String notifyUrl;
    private String type;
    private DeclarationCompanyBuilder company;
    private DeclarationBusinessBuilder business;
    private List<DeclarationBeneficialBuilder> beneficialList;
    private List<DeclarationLegalBuilder> legalList;
    private List<DeclarationAuthorizedBuilder> authorizedList;
    private DeclarationCertificateBuilder certificate;
    private String agreeCooperationAgreement;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public DeclarationBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public DeclarationBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public DeclarationBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public DeclarationBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public String getType() {
        return this.type;
    }

    public DeclarationCompanyBuilder getCompany() {
        return this.company;
    }

    public DeclarationBusinessBuilder getBusiness() {
        return this.business;
    }

    public List<DeclarationBeneficialBuilder> getBeneficialList() {
        return this.beneficialList;
    }

    public List<DeclarationLegalBuilder> getLegalList() {
        return this.legalList;
    }

    public List<DeclarationAuthorizedBuilder> getAuthorizedList() {
        return this.authorizedList;
    }

    public DeclarationCertificateBuilder getCertificate() {
        return this.certificate;
    }

    public String getAgreeCooperationAgreement() {
        return this.agreeCooperationAgreement;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCompany(DeclarationCompanyBuilder company) {
        this.company = company;
    }

    public void setBusiness(DeclarationBusinessBuilder business) {
        this.business = business;
    }

    public void setBeneficialList(List<DeclarationBeneficialBuilder> beneficialList) {
        this.beneficialList = beneficialList;
    }

    public void setLegalList(List<DeclarationLegalBuilder> legalList) {
        this.legalList = legalList;
    }

    public void setAuthorizedList(List<DeclarationAuthorizedBuilder> authorizedList) {
        this.authorizedList = authorizedList;
    }

    public void setCertificate(DeclarationCertificateBuilder certificate) {
        this.certificate = certificate;
    }

    public void setAgreeCooperationAgreement(String agreeCooperationAgreement) {
        this.agreeCooperationAgreement = agreeCooperationAgreement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeclarationBuilder)) {
            return false;
        }
        DeclarationBuilder other = (DeclarationBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$subMerchantId = this.getSubMerchantId();
        String other$subMerchantId = other.getSubMerchantId();
        if (this$subMerchantId == null ? other$subMerchantId != null : !this$subMerchantId.equals(other$subMerchantId)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        DeclarationCompanyBuilder this$company = this.getCompany();
        DeclarationCompanyBuilder other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)this$company).equals(other$company)) {
            return false;
        }
        DeclarationBusinessBuilder this$business = this.getBusiness();
        DeclarationBusinessBuilder other$business = other.getBusiness();
        if (this$business == null ? other$business != null : !((Object)this$business).equals(other$business)) {
            return false;
        }
        List<DeclarationBeneficialBuilder> this$beneficialList = this.getBeneficialList();
        List<DeclarationBeneficialBuilder> other$beneficialList = other.getBeneficialList();
        if (this$beneficialList == null ? other$beneficialList != null : !((Object)this$beneficialList).equals(other$beneficialList)) {
            return false;
        }
        List<DeclarationLegalBuilder> this$legalList = this.getLegalList();
        List<DeclarationLegalBuilder> other$legalList = other.getLegalList();
        if (this$legalList == null ? other$legalList != null : !((Object)this$legalList).equals(other$legalList)) {
            return false;
        }
        List<DeclarationAuthorizedBuilder> this$authorizedList = this.getAuthorizedList();
        List<DeclarationAuthorizedBuilder> other$authorizedList = other.getAuthorizedList();
        if (this$authorizedList == null ? other$authorizedList != null : !((Object)this$authorizedList).equals(other$authorizedList)) {
            return false;
        }
        DeclarationCertificateBuilder this$certificate = this.getCertificate();
        DeclarationCertificateBuilder other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        String this$agreeCooperationAgreement = this.getAgreeCooperationAgreement();
        String other$agreeCooperationAgreement = other.getAgreeCooperationAgreement();
        return !(this$agreeCooperationAgreement == null ? other$agreeCooperationAgreement != null : !this$agreeCooperationAgreement.equals(other$agreeCooperationAgreement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeclarationBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $subMerchantId = this.getSubMerchantId();
        result = result * 59 + ($subMerchantId == null ? 43 : $subMerchantId.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        DeclarationCompanyBuilder $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)$company).hashCode());
        DeclarationBusinessBuilder $business = this.getBusiness();
        result = result * 59 + ($business == null ? 43 : ((Object)$business).hashCode());
        List<DeclarationBeneficialBuilder> $beneficialList = this.getBeneficialList();
        result = result * 59 + ($beneficialList == null ? 43 : ((Object)$beneficialList).hashCode());
        List<DeclarationLegalBuilder> $legalList = this.getLegalList();
        result = result * 59 + ($legalList == null ? 43 : ((Object)$legalList).hashCode());
        List<DeclarationAuthorizedBuilder> $authorizedList = this.getAuthorizedList();
        result = result * 59 + ($authorizedList == null ? 43 : ((Object)$authorizedList).hashCode());
        DeclarationCertificateBuilder $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        String $agreeCooperationAgreement = this.getAgreeCooperationAgreement();
        result = result * 59 + ($agreeCooperationAgreement == null ? 43 : $agreeCooperationAgreement.hashCode());
        return result;
    }

    public String toString() {
        return "DeclarationBuilder(merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ", subMerchantId=" + this.getSubMerchantId() + ", notifyUrl=" + this.getNotifyUrl() + ", type=" + this.getType() + ", company=" + this.getCompany() + ", business=" + this.getBusiness() + ", beneficialList=" + this.getBeneficialList() + ", legalList=" + this.getLegalList() + ", authorizedList=" + this.getAuthorizedList() + ", certificate=" + this.getCertificate() + ", agreeCooperationAgreement=" + this.getAgreeCooperationAgreement() + ")";
    }
}

