/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.tls.support_1_6;

import com.ehking.sdk.tls.support_1_6.SSLSessionImpl;
import com.ehking.sdk.tls.support_1_6.TLSClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.by_1_52.crypto.tls.TlsClientProtocol;

public class SSLSocketImpl
extends SSLSocket {
    private final TLSClient tlsClient;
    private final TlsClientProtocol tlsClientProtocol;

    public SSLSocketImpl(Socket socket, String hostName) throws IOException {
        this.tlsClient = new TLSClient(hostName, socket);
        this.tlsClientProtocol = new TlsClientProtocol(socket.getInputStream(), socket.getOutputStream(), new SecureRandom());
    }

    @Override
    public InputStream getInputStream() {
        return this.tlsClientProtocol.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.tlsClientProtocol.getOutputStream();
    }

    @Override
    public synchronized void close() throws IOException {
        this.tlsClientProtocol.close();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.tlsClient.getCipherSuitesString();
    }

    @Override
    public String[] getEnabledProtocols() {
        return null;
    }

    @Override
    public boolean getNeedClientAuth() {
        return false;
    }

    @Override
    public SSLSession getSession() {
        return new SSLSessionImpl(this.tlsClient);
    }

    @Override
    public String[] getSupportedProtocols() {
        return null;
    }

    @Override
    public boolean getUseClientMode() {
        return false;
    }

    @Override
    public boolean getWantClientAuth() {
        return false;
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
    }

    @Override
    public void setEnableSessionCreation(boolean arg0) {
    }

    @Override
    public void setEnabledCipherSuites(String[] arg0) {
    }

    @Override
    public void setEnabledProtocols(String[] arg0) {
    }

    @Override
    public void setNeedClientAuth(boolean arg0) {
    }

    @Override
    public void setUseClientMode(boolean arg0) {
    }

    @Override
    public void setWantClientAuth(boolean arg0) {
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.tlsClient.getCipherSuitesString();
    }

    @Override
    public void startHandshake() throws IOException {
        this.tlsClientProtocol.connect(this.tlsClient);
    }
}

