/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.transfer.utils;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;

public class UpiJoseUtils {
    public static String signJws(String message, String kid, String uuid, String requestPath, String appId, PrivateKey privateK) {
        JwsHeaders jwsHeaders = new JwsHeaders(SignatureAlgorithm.RS256);
        jwsHeaders.setKeyId(kid);
        LinkedList<String> crit = new LinkedList<String>();
        crit.add("UPI-UUID");
        crit.add("UPI-TIMESTAMP");
        crit.add("UPI-APPID");
        if (!StringUtils.isEmpty((String)requestPath)) {
            crit.add("UPI-REQPATH");
        }
        jwsHeaders.setCritical(crit);
        if (StringUtils.isEmpty((String)uuid)) {
            jwsHeaders.setHeader("UPI-UUID", (Object)UUID.randomUUID().toString().replaceAll("-", ""));
        } else {
            jwsHeaders.setHeader("UPI-UUID", (Object)uuid);
        }
        jwsHeaders.setHeader("UPI-TIMESTAMP", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
        jwsHeaders.setHeader("UPI-APPID", (Object)appId);
        if (!StringUtils.isEmpty((String)requestPath)) {
            jwsHeaders.setHeader("UPI-REQPATH", (Object)requestPath);
        }
        JwsCompactProducer jwsProducer = new JwsCompactProducer(jwsHeaders, message);
        jwsProducer.signWith((JwsSignatureProvider)new PrivateKeyJwsSignatureProvider(privateK, SignatureAlgorithm.RS256));
        return jwsProducer.getSignedEncodedJws();
    }

    public static String signJws(String message, String kid, String requestPath, String appId, PrivateKey privateK) {
        return UpiJoseUtils.signJws(message, kid, null, requestPath, appId, privateK);
    }

    public static boolean validateJws(String jwsStr, PublicKey publicK) {
        JwsCompactConsumer jwsCompactConsumer = new JwsCompactConsumer(jwsStr);
        return jwsCompactConsumer.verifySignatureWith(publicK, SignatureAlgorithm.RS256);
    }

    public static String encryptJwe(String content, PublicKey publicK, String kid) throws UnsupportedEncodingException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        RSAKeyEncryptionAlgorithm rsaKeyEncryptionAlgorithm = new RSAKeyEncryptionAlgorithm((RSAPublicKey)publicK, KeyAlgorithm.RSA1_5, false);
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        byte[] cek = uuid.getBytes("UTF-8");
        byte[] iv = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16).getBytes("UTF-8");
        AesCbcHmacJweEncryption encryptor = new AesCbcHmacJweEncryption(ContentAlgorithm.A128CBC_HS256, cek, iv, (KeyEncryptionProvider)rsaKeyEncryptionAlgorithm);
        JweHeaders jweHeaders = new JweHeaders(KeyAlgorithm.RSA1_5, ContentAlgorithm.A128CBC_HS256);
        jweHeaders.setKeyId(kid);
        return encryptor.encrypt(content.getBytes("UTF-8"), jweHeaders);
    }

    public static String decryptJwe(String jweContent, PrivateKey privateK) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        RSAKeyDecryptionAlgorithm keyDecryptionAlgorithm = new RSAKeyDecryptionAlgorithm((RSAPrivateKey)privateK, KeyAlgorithm.RSA1_5, false);
        AesCbcHmacJweDecryption decryptor = new AesCbcHmacJweDecryption((KeyDecryptionProvider)keyDecryptionAlgorithm, ContentAlgorithm.A128CBC_HS256);
        JweDecryptionOutput decrypt = decryptor.decrypt(jweContent);
        return decrypt.getContentText();
    }
}

