/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.transfer.utils;

import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;

public class JwsUtil {
    public static String packageJws(String detachedJwsContent, String payload) {
        String[] parts = JwsUtil.getCompactParts(detachedJwsContent);
        String payloadBase64Url = Base64UrlUtility.encode((String)payload);
        String jwsContent = parts[0] + "." + payloadBase64Url + "." + parts[2];
        return jwsContent;
    }

    public static String detachedJwsContent(String jwsContent) {
        String[] parts = JwsUtil.getCompactParts(jwsContent);
        String detachedJwsContent = parts[0] + ".." + parts[2];
        return detachedJwsContent;
    }

    public static String[] getCompactParts(String compactContent) {
        if (compactContent.startsWith("\"") && compactContent.endsWith("\"")) {
            compactContent = compactContent.substring(1, compactContent.length() - 1);
        }
        return compactContent.split("\\.");
    }

    public static String getJwsKid(String jwsContent) {
        JwsCompactConsumer jwsCompactConsumer = new JwsCompactConsumer(jwsContent);
        return jwsCompactConsumer.getJwsHeaders().getKeyId();
    }

    public static String getJweKid(String jweContent) {
        JweCompactConsumer consumer = new JweCompactConsumer(jweContent);
        return consumer.getJweHeaders().getKeyId();
    }

    public static String getJwsUuid(String jwsContent) {
        JwsCompactConsumer jwsCompactConsumer = new JwsCompactConsumer(jwsContent);
        return (String)jwsCompactConsumer.getJwsHeaders().getHeader("UPI-UUID");
    }
}

