/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.transfer.reader;

import com.ehking.sdk.ConfigurationUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderCertificate {
    static final Logger LOGGER = LoggerFactory.getLogger(ReaderCertificate.class);
    private PublicKey serverPublicKey;
    static final Map<String, PrivateKey> cache = new ConcurrentHashMap<String, PrivateKey>();
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey readPrivateKey(String merchantId) throws Exception {
        if (cache.containsKey(merchantId)) {
            return cache.get(merchantId);
        }
        this.lock.lock();
        try {
            if (cache.containsKey(merchantId)) {
                PrivateKey privateKey = cache.get(merchantId);
                return privateKey;
            }
            String keyPath = ConfigurationUtils.getRemittanceTransferPrivateKey(merchantId);
            if (StringUtils.isBlank((CharSequence)keyPath)) {
                throw new IllegalArgumentException("no private key configuration , merchantId:[" + merchantId + "]");
            }
            String password = ConfigurationUtils.getRemittanceTransferPrivateKeyPassword(merchantId);
            char[] pwd = this.getPasswordChars(password);
            PrivateKey privateKey = this.loadCertificateString(keyPath, pwd);
            cache.put(merchantId, privateKey);
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PublicKey readPublicKey() throws Exception {
        if (this.serverPublicKey != null) {
            return this.serverPublicKey;
        }
        this.lock.lock();
        try {
            if (this.serverPublicKey != null) {
                PublicKey publicKey = this.serverPublicKey;
                return publicKey;
            }
            this.serverPublicKey = this.parsePublicKey().getPublicKey();
        }
        finally {
            this.lock.unlock();
        }
        return this.serverPublicKey;
    }

    public X509Certificate parsePublicKey() throws Exception {
        X509Certificate x509Certificate = null;
        InputStream fileInputStream = null;
        String path = ConfigurationUtils.getRemittanceTransferServerPublicKey();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("no server public key configuration");
        }
        try {
            fileInputStream = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("not found server public key file in the absolute path , try the relative path , keyPath:[" + path + "]");
        }
        if (null == fileInputStream) {
            fileInputStream = this.getClass().getResourceAsStream(path);
        }
        if (null == fileInputStream) {
            throw new IllegalArgumentException("not found server public key file, keyPath:[" + path + "]");
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (x509Certificate != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return x509Certificate;
    }

    private KeyStore loadCertificate(String keyPath, char[] password) throws Exception {
        KeyStore ks;
        InputStream fis = null;
        if (StringUtils.isBlank((CharSequence)keyPath)) {
            throw new IllegalArgumentException("no private key configuration , keyPath:[" + keyPath + "]");
        }
        try {
            fis = new FileInputStream(keyPath);
        }
        catch (Exception e) {
            LOGGER.warn("not found private key file in the absolute path , try the relative path , keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        if (null == fis) {
            fis = this.getClass().getResourceAsStream(keyPath);
        }
        if (null == fis) {
            throw new IllegalArgumentException("not found private key file, keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(fis, password);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ks;
    }

    private PrivateKey loadCertificateString(String keyPath, char[] password) throws Exception {
        KeyStore ks = this.loadCertificate(keyPath, password);
        Enumeration<String> enumas = ks.aliases();
        String keyAlias = null;
        if (enumas.hasMoreElements()) {
            keyAlias = enumas.nextElement();
        }
        return (PrivateKey)ks.getKey(keyAlias, password);
    }

    private char[] getPasswordChars(String password) {
        return StringUtils.isNotBlank((CharSequence)password) ? password.toCharArray() : null;
    }
}

