/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.transfer.executer;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.remittance.transfer.builder.RemittanceTransferOrderBuilder;
import com.ehking.sdk.remittance.transfer.builder.RemittanceTransferQueryBuilder;
import com.ehking.sdk.remittance.transfer.reader.ReaderCertificate;
import com.ehking.sdk.remittance.transfer.utils.JwsUtil;
import com.ehking.sdk.remittance.transfer.utils.UpiJoseUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemittanceTransferOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RemittanceTransferOrderExecuter.class);
    private static ReaderCertificate readerCertificate = new ReaderCertificate();

    public void order(RemittanceTransferOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject jsonObject = builder.jsonBuild();
            LOGGER.info("RemittanceTransferOrderExecuter requestData: {}", (Object)JSONObject.toJSONString((Object)jsonObject));
            String sign = this.jwsContent(jsonObject.getString("merchantID"), JSONObject.toJSONString((Object)jsonObject), "/remittance/transfer/remit");
            String result = RemittanceTransferOrderExecuter.sendPost(ConfigurationUtils.getRemittanceTransferOrderUrl(), JSONObject.toJSONString((Object)jsonObject), sign);
            LOGGER.info("RemittanceTransferOrderExecuter responseData: {}", (Object)result);
            JSONObject response = JSONObject.parseObject((String)result);
            if ("00".equals(response.getJSONObject("msgResponse").getString("responseCode"))) {
                resultListener.success(response);
            } else {
                resultListener.failure(response);
            }
        }
        catch (Exception e) {
            LOGGER.error("RemittanceTransferOrderExecuter order error : ", (Throwable)e);
        }
    }

    private String jwsContent(String merchantId, String requestData, String requestPath) {
        String detachedJwsContent = "";
        try {
            String privateKeyKid = ConfigurationUtils.getRemittanceTransferPrivateKid();
            String unionIIN = ConfigurationUtils.getRemittanceTransferIin();
            String jwsContent = UpiJoseUtils.signJws(requestData, privateKeyKid, requestPath, unionIIN, readerCertificate.readPrivateKey(merchantId));
            detachedJwsContent = JwsUtil.detachedJwsContent(jwsContent);
            LOGGER.info("RemittanceTransferAccountConfirmExecuter jwsContent Signature : {}", (Object)detachedJwsContent);
        }
        catch (Exception e) {
            LOGGER.error("RemittanceTransferAccountConfirmExecuter jwsContent error : ", (Throwable)e);
        }
        return detachedJwsContent;
    }

    private static String sendPost(String url, String data, String sign) throws ParseException, IOException {
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setHeader("UPI-JWS", sign);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    public void query(RemittanceTransferQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject jsonObject = builder.jsonBuild();
            String sign = this.jwsContent(jsonObject.getString("merchantID"), JSONObject.toJSONString((Object)jsonObject), "/remittance/transfer/query");
            String responseStr = RemittanceTransferOrderExecuter.sendPost(ConfigurationUtils.getRemittanceTransferQueryUrl(), jsonObject.toJSONString(), sign);
            JSONObject response = JSONObject.parseObject((String)responseStr);
            this.callback(response, listener);
        }
        catch (Exception e) {
            LOGGER.error("RemittanceTransferOrderExecuter query error : ", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    @Override
    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject msgResponse = responseData.getJSONObject("msgResponse");
        JSONObject origMsgResponse = responseData.getJSONObject("origMsgResponse");
        String status = msgResponse.getString("responseCode");
        if (status != null && !status.equals("")) {
            if ("00".equals(status)) {
                String oriStatus = origMsgResponse.getString("origResponseCode");
                if ("00".equals(oriStatus) || "A2".equals(oriStatus) || "A4".equals(oriStatus) || "A5".equals(oriStatus) || "A6".equals(oriStatus)) {
                    listener.success(responseData);
                } else if ("68".equals(oriStatus) || "90".equals(oriStatus) || "98".equals(oriStatus)) {
                    listener.processing(responseData);
                } else {
                    listener.failure(responseData);
                }
            } else {
                listener.pending(responseData);
            }
        }
    }
}

