/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.transfer.executer;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.remittance.transfer.builder.RemittanceAccountConfirmBuilder;
import com.ehking.sdk.remittance.transfer.reader.ReaderCertificate;
import com.ehking.sdk.remittance.transfer.utils.JwsUtil;
import com.ehking.sdk.remittance.transfer.utils.UpiJoseUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemittanceTransferAccountConfirmExecuter {
    static final Logger LOGGER = LoggerFactory.getLogger(RemittanceTransferAccountConfirmExecuter.class);
    private static ReaderCertificate readerCertificate = new ReaderCertificate();

    public void accountConfirm(RemittanceAccountConfirmBuilder builder, ResultListener resultListener) {
        try {
            JSONObject jsonObject = builder.jsonBuild();
            LOGGER.info("requestData:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            String sign = this.jwsContent(jsonObject.getString("merchantID"), JSONObject.toJSONString((Object)jsonObject), "/remittance/transfer/accountconfirm");
            String result = RemittanceTransferAccountConfirmExecuter.sendPost(ConfigurationUtils.getRemittanceTransferAccountConfirmUrl(), JSONObject.toJSONString((Object)jsonObject), sign);
            LOGGER.info("responseData:{}", (Object)result);
            JSONObject response = JSONObject.parseObject((String)result);
            JSONObject msgResponse = response.getJSONObject("msgResponse");
            if (!"00".equals(msgResponse.getString("responseCode"))) {
                throw new ResponseException(response);
            }
            resultListener.success(response);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
    }

    private String jwsContent(String merchantId, String requestData, String requestPath) {
        String detachedJwsContent = "";
        try {
            String privateKeyKid = ConfigurationUtils.getRemittanceTransferPrivateKid();
            String unionIIN = ConfigurationUtils.getRemittanceTransferIin();
            String jwsContent = UpiJoseUtils.signJws(requestData, privateKeyKid, requestPath, unionIIN, readerCertificate.readPrivateKey(merchantId));
            detachedJwsContent = JwsUtil.detachedJwsContent(jwsContent);
            LOGGER.info("RemittanceTransferAccountConfirmExecuter jwsContent Signature : {}", (Object)detachedJwsContent);
        }
        catch (Exception e) {
            LOGGER.error("RemittanceTransferAccountConfirmExecuter jwsContent error : ", (Throwable)e);
        }
        return detachedJwsContent;
    }

    public static String sendPost(String url, String data, String sign) throws ParseException, IOException {
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setHeader("UPI-JWS", sign);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String status = responseData.getString("responseCode");
        if (status != null && !status.equals("")) {
            if ("00".equals(status)) {
                listener.success(responseData);
            } else {
                listener.failure(responseData);
            }
        }
    }
}

