/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.remittance.builder.RemittanceVoucherCreateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemittanceVoucherExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RemittanceVoucherExecutor.class);

    public void bothCreate(RemittanceVoucherCreateBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("RemittanceVoucherExecutor bothCreate requestData:[" + requestData.toJSONString() + "],orderUrl:[" + ConfigurationUtils.getRemittanceVoucherCreateUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRemittanceVoucherCreateUrl(), requestData);
        LOGGER.debug("RemittanceVoucherExecutor bothCreate responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("RemittanceVoucherExecutor bothCreate responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

