/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.remittance.builder.RemittanceCancelBuilder;
import com.ehking.sdk.remittance.builder.RemittanceOrderBuilder;
import com.ehking.sdk.remittance.builder.RemittanceQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemittanceOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RemittanceOrderExecuter.class);

    public void bothOrder(RemittanceOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("RemittanceOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],orderUrl:[" + ConfigurationUtils.getRemittanceOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRemittanceOrderUrl(), requestData);
        LOGGER.debug("RemittanceOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("RemittanceOrderExecuter orderV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(RemittanceQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("RemittanceOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRemittanceQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("RemittanceOrderExecuter queryV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("RemittanceOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothCancel(RemittanceCancelBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException("ResultListener must not be null");
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("RemittanceOrderExecuter bothCancel requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRemittanceCancelUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("RemittanceOrderExecuter bothCancel decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("RemittanceOrderExecuter bothCancel responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

