/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.remittance.builder.RemittanceCardBinVerifyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemittanceCardBinExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RemittanceCardBinExecuter.class);

    public void bothCardBinVerify(RemittanceCardBinVerifyBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("RemittanceCardBinExecuter bothCardBinVerify requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRemittanceCardBinVerifyUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("RemittanceCardBinExecuter bothCardBinVerify decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("RemittanceCardBinExecuter bothCardBinVerify responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

