/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class RemittanceQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String partnerId;

    public RemittanceQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RemittanceQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public RemittanceQueryBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }
}

