/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.remittance.entity.RemittancePayer2PayeeProve;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RemittancePayer2PayeeBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String partnerId;
    private String payerName;
    private String payerIdType;
    private String payerIdNumber;
    private String payeeName;
    private String payeeNameZh;
    private String payeeIdNumber;
    private String payeeIdType;
    private String payeeRelation;
    private String remark;
    private String notifyUrl;
    private List<RemittancePayer2PayeeProve> proveList = new LinkedList<RemittancePayer2PayeeProve>();

    public String getPartnerId() {
        return this.partnerId;
    }

    public RemittancePayer2PayeeBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public RemittancePayer2PayeeBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public RemittancePayer2PayeeBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public RemittancePayer2PayeeBuilder setPayerName(String payerName) {
        this.payerName = payerName;
        return this;
    }

    public String getPayerIdType() {
        return this.payerIdType;
    }

    public RemittancePayer2PayeeBuilder setPayerIdType(String payerIdType) {
        this.payerIdType = payerIdType;
        return this;
    }

    public String getPayerIdNumber() {
        return this.payerIdNumber;
    }

    public RemittancePayer2PayeeBuilder setPayerIdNumber(String payerIdNumber) {
        this.payerIdNumber = payerIdNumber;
        return this;
    }

    public String getPayeeName() {
        return this.payeeName;
    }

    public RemittancePayer2PayeeBuilder setPayeeName(String payeeName) {
        this.payeeName = payeeName;
        return this;
    }

    public String getPayeeNameZh() {
        return this.payeeNameZh;
    }

    public RemittancePayer2PayeeBuilder setPayeeNameZh(String payeeNameZh) {
        this.payeeNameZh = payeeNameZh;
        return this;
    }

    public String getPayeeIdNumber() {
        return this.payeeIdNumber;
    }

    public RemittancePayer2PayeeBuilder setPayeeIdNumber(String payeeIdNumber) {
        this.payeeIdNumber = payeeIdNumber;
        return this;
    }

    public String getPayeeIdType() {
        return this.payeeIdType;
    }

    public RemittancePayer2PayeeBuilder setPayeeIdType(String payeeIdType) {
        this.payeeIdType = payeeIdType;
        return this;
    }

    public String getPayeeRelation() {
        return this.payeeRelation;
    }

    public RemittancePayer2PayeeBuilder setPayeeRelation(String payeeRelation) {
        this.payeeRelation = payeeRelation;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public RemittancePayer2PayeeBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public RemittancePayer2PayeeBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public List<RemittancePayer2PayeeProve> getProveList() {
        return this.proveList;
    }

    public RemittancePayer2PayeeBuilder addProveList(RemittancePayer2PayeeProve payer2PayeeProve) {
        this.proveList.add(payer2PayeeProve);
        return this;
    }
}

