/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.remittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.remittance.builder.Payee;
import com.ehking.sdk.remittance.builder.PayeeAccount;
import com.ehking.sdk.remittance.builder.Payer;
import org.apache.commons.lang3.StringUtils;

public class RemittanceOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String currency;
    private String amount;
    private String requestCreditedAmount;
    private String notifyUrl;
    private String tradePostscript;
    private String sourceCountry;
    private String fundPurpose;
    private Payee payee;
    private Payer payer;
    private PayeeAccount payeeAccount;
    private String billMerchantName;
    private String realMerchantId;
    private String partnerCommissionFeeType;
    private String partnerCommissionFeeValue;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public RemittanceOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public RemittanceOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public RemittanceOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getCurrency() {
        return this.currency;
    }

    public RemittanceOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public String getAmount() {
        return this.amount;
    }

    public RemittanceOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public RemittanceOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public String getBillMerchantName() {
        return this.billMerchantName;
    }

    public RemittanceOrderBuilder setBillMerchantName(String billMerchantName) {
        this.billMerchantName = billMerchantName;
        return this;
    }

    public String getRealMerchantId() {
        return this.realMerchantId;
    }

    public RemittanceOrderBuilder setRealMerchantId(String realMerchantId) {
        this.realMerchantId = realMerchantId;
        return this;
    }

    public String getTradePostscript() {
        return this.tradePostscript;
    }

    public RemittanceOrderBuilder setTradePostscript(String tradePostscript) {
        this.tradePostscript = tradePostscript;
        return this;
    }

    public String getSourceCountry() {
        return this.sourceCountry;
    }

    public RemittanceOrderBuilder setSourceCountry(String sourceCountry) {
        this.sourceCountry = sourceCountry;
        return this;
    }

    public String getFundPurpose() {
        return this.fundPurpose;
    }

    public RemittanceOrderBuilder setFundPurpose(String fundPurpose) {
        this.fundPurpose = fundPurpose;
        return this;
    }

    public Payee getPayee() {
        return this.payee;
    }

    public RemittanceOrderBuilder setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public RemittanceOrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public PayeeAccount getPayeeAccount() {
        return this.payeeAccount;
    }

    public RemittanceOrderBuilder setPayeeAccount(PayeeAccount payeeAccount) {
        this.payeeAccount = payeeAccount;
        return this;
    }

    public String getRequestCreditedAmount() {
        return this.requestCreditedAmount;
    }

    public RemittanceOrderBuilder setRequestCreditedAmount(String requestCreditedAmount) {
        this.requestCreditedAmount = requestCreditedAmount;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public RemittanceOrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getPartnerCommissionFeeType() {
        return this.partnerCommissionFeeType;
    }

    public RemittanceOrderBuilder setPartnerCommissionFeeType(String partnerCommissionFeeType) {
        this.partnerCommissionFeeType = partnerCommissionFeeType;
        return this;
    }

    public String getPartnerCommissionFeeValue() {
        return this.partnerCommissionFeeValue;
    }

    public RemittanceOrderBuilder setPartnerCommissionFeeValue(String partnerCommissionFeeValue) {
        this.partnerCommissionFeeValue = partnerCommissionFeeValue;
        return this;
    }
}

