/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.reader;

import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.reader.CertificateReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathCertificateReader
implements CertificateReader {
    static final Logger LOGGER = LoggerFactory.getLogger(PathCertificateReader.class);
    private Base64 base64 = new Base64();
    private String serverPublicKey;
    static final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readPrivateKey(String merchantId) throws Exception {
        if (cache.containsKey(merchantId)) {
            return cache.get(merchantId);
        }
        this.lock.lock();
        try {
            if (cache.containsKey(merchantId)) {
                String string = cache.get(merchantId);
                return string;
            }
            String keyPath = ConfigurationUtils.getClientPrivateKeyPath(merchantId);
            if (StringUtils.isBlank((CharSequence)keyPath)) {
                throw new IllegalArgumentException("no private key configuration , merchantId:[" + merchantId + "]");
            }
            String password = ConfigurationUtils.getClientPrivateKeyPassword(merchantId);
            char[] pwd = this.getPasswordChars(password);
            String privateKeyStr = this.loadCertificateString(keyPath, pwd);
            cache.put(merchantId, privateKeyStr);
            String string = privateKeyStr;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readOldPrivateKey(String merchantId) throws Exception {
        String key = merchantId + "_old";
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        this.lock.lock();
        try {
            if (cache.containsKey(key)) {
                String string = cache.get(key);
                return string;
            }
            String keyPath = ConfigurationUtils.getOldClientPrivateKeyPath(merchantId);
            if (StringUtils.isBlank((CharSequence)keyPath)) {
                throw new IllegalArgumentException("no old private key configuration , merchantId:[" + merchantId + "] ,example:[" + merchantId + ".client.old.private.key.path]");
            }
            String password = ConfigurationUtils.getOldClientPrivateKeyPassword(merchantId);
            char[] pwd = this.getPasswordChars(password);
            String privateKeyStr = this.loadCertificateString(keyPath, pwd);
            cache.put(key, privateKeyStr);
            String string = privateKeyStr;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String readPublicKey() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.serverPublicKey)) {
            return this.serverPublicKey;
        }
        this.lock.lock();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.serverPublicKey)) {
                String string = this.serverPublicKey;
                return string;
            }
            this.serverPublicKey = new String(this.base64.encode(this.parsePublicKey().getPublicKey().getEncoded()));
        }
        finally {
            this.lock.unlock();
        }
        return this.serverPublicKey;
    }

    public X509Certificate parsePublicKey() throws Exception {
        X509Certificate x509Certificate = null;
        InputStream fileInputStream = null;
        String path = ConfigurationUtils.getServerPublicKey();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("no server public key configuration");
        }
        try {
            fileInputStream = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("not found server public key file in the absolute path , try the relative path , keyPath:[" + path + "]");
        }
        if (null == fileInputStream) {
            fileInputStream = this.getClass().getResourceAsStream(path);
        }
        if (null == fileInputStream) {
            throw new IllegalArgumentException("not found server public key file, keyPath:[" + path + "]");
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (x509Certificate != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return x509Certificate;
    }

    private KeyStore loadCertificate(String keyPath, char[] password) throws Exception {
        KeyStore ks;
        InputStream fis = null;
        if (StringUtils.isBlank((CharSequence)keyPath)) {
            throw new IllegalArgumentException("no private key configuration , keyPath:[" + keyPath + "]");
        }
        try {
            fis = new FileInputStream(keyPath);
        }
        catch (Exception e) {
            LOGGER.warn("not found private key file in the absolute path , try the relative path , keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        if (null == fis) {
            fis = this.getClass().getResourceAsStream(keyPath);
        }
        if (null == fis) {
            throw new IllegalArgumentException("not found private key file, keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(fis, password);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ks;
    }

    private String loadCertificateString(String keyPath, char[] password) throws Exception {
        KeyStore ks = this.loadCertificate(keyPath, password);
        Enumeration<String> enumas = ks.aliases();
        String keyAlias = null;
        if (enumas.hasMoreElements()) {
            keyAlias = enumas.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, password);
        return new String(this.base64.encode(privateKey.getEncoded()));
    }

    private char[] getPasswordChars(String password) {
        return StringUtils.isNotBlank((CharSequence)password) ? password.toCharArray() : null;
    }
}

