/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.overseas.listprice.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.overseas.listprice.builder.OverseasListPriceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseasListPriceExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OverseasListPriceExecuter.class);

    public void bidV_3(OverseasListPriceBuilder builder, ResultListener resultListener) {
        LOGGER.debug("OverseasListPriceExecuter bidV_3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("OverseasListPriceExecuter bidV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOverseasListPriceUrl(), requestData);
        LOGGER.debug("OverseasListPriceExecuter bidV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("OverseasListPriceExecuter bidV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

