/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.overseas.listprice.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class OverseasListPriceBuilder
extends BuilderSupport {
    private String merchantId;
    private String sourceCurrency;
    private String businessType;
    private String partnerId;

    public OverseasListPriceBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public OverseasListPriceBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public OverseasListPriceBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }
}

