/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.overseas.account.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.overseas.account.builder.AccountQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(AccountExecuter.class);

    public void bothQuery(AccountQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("AccountExecuter queryV_3 requestData : {}", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOverseasAccountQueryUrl(), requestData);
            LOGGER.info("AccountExecuter queryV_3 responseStr : {}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("AccountExecuter queryV_3 decrypt error responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        LOGGER.info("AccountExecuter account decryptCallback: {}", (Object)responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

