/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.overseas.account.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.RequestException;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.overseas.account.builder.AccountBalanceQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountBalanceExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(AccountBalanceExecuter.class);

    public void bothQuery(AccountBalanceQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject responseData = null;
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("AccountBalanceExecuter queryV_3 requestData : {}", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOverseasAccountBalanceQueryUrl(), requestData);
            LOGGER.info("AccountBalanceExecuter queryV_3 decrypt responseStr : {}", (Object)responseStr);
            responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            LOGGER.info("AccountBalanceExecuter queryV_3 decrypt status : {}", (Object)status);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("AccountBalanceExecuter queryV_3 decrypt responseData : {}", (Object)responseData);
                listener.failure(responseData);
                return;
            }
            LOGGER.info("AccountBalanceExecuter queryV_3 responseStr : {}", (Object)responseStr);
            this.bothCipherCallback(responseData, listener);
        }
        catch (RequestException e) {
            LOGGER.error("request order exception", (Throwable)e);
            listener.failure(CipherWrapper.bothDecryptWrap(responseData));
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

