/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.offline.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.offline.entity.OfflineInspectDetail;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class OfflineInspectBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String remark;
    private String notifyUrl;
    private String refundUrl;
    private List<OfflineInspectDetail> inspectDetails = new ArrayList<OfflineInspectDetail>();

    public OfflineInspectBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OfflineInspectBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OfflineInspectBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public OfflineInspectBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OfflineInspectBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OfflineInspectBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OfflineInspectBuilder setRefundUrl(String refundUrl) {
        this.refundUrl = refundUrl;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public void setInspectDetails(List<OfflineInspectDetail> inspectDetails) {
        this.inspectDetails = inspectDetails;
    }
}

