/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.inspect.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.inspect.builder.InspectBuilder;
import com.ehking.sdk.inspect.builder.InspectQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(InspectOrderExecuter.class);

    public void inspectV_3(InspectBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                LOGGER.info("CpPayOrderExecuter inspectV_3 builder: {}", (Object)JSON.toJSONString((Object)builder));
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("CpPayOrderExecuter inspectV_3 requestData: {}", (Object)requestData.toJSONString());
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getInspectUploadUrl(), requestData);
                LOGGER.info("CpPayOrderExecuter inspectV_3 responseStr: {}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("CpPayOrderExecuter orderV_3 responseStr111: {}", (Object)responseData);
                this.bothVerifyHmacOrder(responseData);
                LOGGER.info("CpPayOrderExecuter orderV_3 responseStr: {}", (Object)responseData);
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("CpPayOrderExecuter inspectV_3 error : ", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void inspectCallbackV_3(JSONObject responseData, ResultListener listener) {
        LOGGER.info("CpPayOrderExecuter inspectCallbackV_3 responseData: {}", (Object)responseData);
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CpPayOrderExecuter inspectCallbackV_3 data: {}", (Object)data);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            if (Constants.REFUSE.equals(status)) {
                listener.failure(data);
                return;
            }
            throw new ResponseException(data);
        }
        listener.success(data);
    }

    public void inspectQueryV_3(InspectQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("CpPayOrderExecuter inspectQueryV_3 requestData: {}", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getInspectUploadQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.debug("CpPayOrderExecuter inspectQueryV_3 responseStr: {}", (Object)responseStr);
            this.inspectCallbackV_3(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("CpPayOrderExecuter inspectQueryV_3 error : ", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

