/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fx.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.fx.builder.FxCreateQuotationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxQuotationExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(FxQuotationExecutor.class);

    public void createQuotation(FxCreateQuotationBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("createQuotation requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFxCreateQuotationUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("createQuotation responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("createQuotation error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("createQuotation exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else if (Constants.PROCESSING.equals(status)) {
            listener.pending(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

