/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fx.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.fx.builder.FxOrderCreateBuilder;
import com.ehking.sdk.fx.builder.FxOrderQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxOrderExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(FxOrderExecutor.class);

    public void createOrder(FxOrderCreateBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("createOrder requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFxCreateOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("createOrder responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("createOrder error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("createOrder exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void queryOrder(FxOrderQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("queryOrder requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFxQueryOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("queryOrder responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("queryOrder error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("queryOrder exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void notify(JSONObject responseData, ResultListener paymentListener) {
        LOGGER.info(" notify responseData: {}", (Object)responseData);
        if (paymentListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("notify data: {}", (Object)data);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                paymentListener.failure(data);
                return;
            }
            if (Constants.INIT.equals(status) || Constants.PROCESSING.equals(status)) {
                paymentListener.pending(data);
                return;
            }
            throw new ResponseException(data);
        }
        paymentListener.success(data);
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else if (Constants.PROCESSING.equals(status)) {
            listener.pending(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

