/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fx.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class FxCreateQuotationBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String sellCurrency;
    private String sellAmount;
    private String buyCurrency;
    private String buyAmount;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    public FxCreateQuotationBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public FxCreateQuotationBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public FxCreateQuotationBuilder setSellCurrency(String sellCurrency) {
        this.sellCurrency = sellCurrency;
        return this;
    }

    public FxCreateQuotationBuilder setSellAmount(String sellAmount) {
        this.sellAmount = sellAmount;
        return this;
    }

    public FxCreateQuotationBuilder setBuyCurrency(String buyCurrency) {
        this.buyCurrency = buyCurrency;
        return this;
    }

    public FxCreateQuotationBuilder setBuyAmount(String buyAmount) {
        this.buyAmount = buyAmount;
        return this;
    }

    public FxCreateQuotationBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }
}

