/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fastremittance.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.fastremittance.builder.FrRemitOrderCancelBuilder;
import com.ehking.sdk.fastremittance.builder.FrRemitOrderCreateBuilder;
import com.ehking.sdk.fastremittance.builder.FrRemitOrderQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrRemitOrderExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(FrRemitOrderExecutor.class);

    public void createRemitOrder(FrRemitOrderCreateBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("createRemitOrder requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFrCreateRemitOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("createRemitOrder responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("createRemitOrder error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("createRemitOrder exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void queryRemitOrder(FrRemitOrderQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("queryRemitOrder requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFrQueryRemitOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("queryRemitOrder responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("queryRemitOrder error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("queryRemitOrder exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void notify(JSONObject responseData, ResultListener paymentListener) {
        LOGGER.info(" notify responseData: {}", (Object)responseData);
        if (paymentListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("notify data: {}", (Object)data);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                paymentListener.failure(data);
                return;
            }
            if (Constants.INIT.equals(status) || Constants.PROCESSING.equals(status)) {
                paymentListener.pending(data);
                return;
            }
            throw new ResponseException(data);
        }
        paymentListener.success(data);
    }

    public void cancelRemitOrder(FrRemitOrderCancelBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("cancelRemitOrder requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFrCancelRemitOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("cancelRemitOrder responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("cancelRemitOrder error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("cancelRemitOrder exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else if (Constants.PROCESSING.equals(status)) {
            listener.pending(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

