/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fastremittance.executor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.Constants;
import com.ehking.sdk.HttpClientUtils;
import com.ehking.sdk.exception.ResponseException;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import com.ehking.sdk.fastremittance.builder.FrCreateQuotationBuilder;
import com.ehking.sdk.fastremittance.builder.FrQueryQuotationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrQuotationExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(FrQuotationExecutor.class);

    public void createQuotation(FrCreateQuotationBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("createQuotation requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFrCreateQuotationUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("createQuotation responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("createQuotation error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("createQuotation exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void queryQuotation(FrQueryQuotationBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("queryQuotation requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getFrQueryQuotationUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("queryQuotation responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status) || "406".equals(status)) {
                LOGGER.info("queryQuotation error decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.decryptCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("queryQuotation exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    private void decryptCallback(JSONObject responseData, ResultListener listener) {
        JSONObject decryptData = super.callback(responseData);
        String status = decryptData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(decryptData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(decryptData);
        } else if (Constants.PROCESSING.equals(status)) {
            listener.pending(decryptData);
        } else {
            throw new ResponseException(decryptData);
        }
    }
}

