/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fastremittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.fastremittance.entity.FrRemitPayee;
import com.ehking.sdk.fastremittance.entity.FrRemitPayeeAccount;
import com.ehking.sdk.fastremittance.entity.FrRemitPayer;
import com.ehking.sdk.fastremittance.entity.FrRemitProveFile;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FrRemitOrderCreateBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String remitPurpose;
    private String quotationId;
    private String notifyUrl;
    private String originalCountry;
    private String targetAmount;
    private String targetCurrency;
    private String postscript;
    private String remark;
    private String extraRemark;
    private String partnerCommissionFeeType;
    private String partnerCommissionFeeValue;
    private String payeeRequestId;
    private FrRemitPayer payer;
    private FrRemitPayee payee;
    private FrRemitPayeeAccount payeeAccount;
    private List<FrRemitProveFile> proveFiles = new LinkedList<FrRemitProveFile>();

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    public FrRemitOrderCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public FrRemitOrderCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public FrRemitOrderCreateBuilder setRemitPurpose(String remitPurpose) {
        this.remitPurpose = remitPurpose;
        return this;
    }

    public FrRemitOrderCreateBuilder setQuotationId(String quotationId) {
        this.quotationId = quotationId;
        return this;
    }

    public FrRemitOrderCreateBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public FrRemitOrderCreateBuilder setOriginalCountry(String originalCountry) {
        this.originalCountry = originalCountry;
        return this;
    }

    public FrRemitOrderCreateBuilder setTargetAmount(String targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    public FrRemitOrderCreateBuilder setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
        return this;
    }

    public FrRemitOrderCreateBuilder setPostscript(String postscript) {
        this.postscript = postscript;
        return this;
    }

    public FrRemitOrderCreateBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public FrRemitOrderCreateBuilder setExtraRemark(String extraRemark) {
        this.extraRemark = extraRemark;
        return this;
    }

    public void setPayer(FrRemitPayer payer) {
        this.payer = payer;
    }

    public void setPayee(FrRemitPayee payee) {
        this.payee = payee;
    }

    public void setPayeeAccount(FrRemitPayeeAccount payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public void addProveFile(FrRemitProveFile proveFile) {
        this.proveFiles.add(proveFile);
    }

    public FrRemitOrderCreateBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public FrRemitOrderCreateBuilder setPartnerCommissionFeeValue(String partnerCommissionFeeValue) {
        this.partnerCommissionFeeValue = partnerCommissionFeeValue;
        return this;
    }

    public FrRemitOrderCreateBuilder setPartnerCommissionFeeType(String partnerCommissionFeeType) {
        this.partnerCommissionFeeType = partnerCommissionFeeType;
        return this;
    }

    public String getPayeeRequestId() {
        return this.payeeRequestId;
    }

    public FrRemitOrderCreateBuilder setPayeeRequestId(String payeeRequestId) {
        this.payeeRequestId = payeeRequestId;
        return this;
    }
}

