/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fastremittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.fastremittance.entity.FrPayeeAccount;
import org.apache.commons.lang3.StringUtils;

public class FrPayeeCreateBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String remitPurpose;
    private String payeeType;
    private String fullName;
    private String lastName;
    private String firstName;
    private String companyName;
    private String country;
    private String address;
    private String phoneNumber;
    private String email;
    private String idType;
    private String idNo;
    private FrPayeeAccount payeeAccount;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public FrPayeeCreateBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public FrPayeeCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public FrPayeeCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getRemitPurpose() {
        return this.remitPurpose;
    }

    public FrPayeeCreateBuilder setRemitPurpose(String remitPurpose) {
        this.remitPurpose = remitPurpose;
        return this;
    }

    public String getPayeeType() {
        return this.payeeType;
    }

    public FrPayeeCreateBuilder setPayeeType(String payeeType) {
        this.payeeType = payeeType;
        return this;
    }

    public String getFullName() {
        return this.fullName;
    }

    public FrPayeeCreateBuilder setFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String getCountry() {
        return this.country;
    }

    public FrPayeeCreateBuilder setCountry(String country) {
        this.country = country;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public FrPayeeCreateBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public FrPayeeCreateBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public FrPayeeCreateBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getIdType() {
        return this.idType;
    }

    public FrPayeeCreateBuilder setIdType(String idType) {
        this.idType = idType;
        return this;
    }

    public String getIdNo() {
        return this.idNo;
    }

    public FrPayeeCreateBuilder setIdNo(String idNo) {
        this.idNo = idNo;
        return this;
    }

    public FrPayeeAccount getPayeeAccount() {
        return this.payeeAccount;
    }

    public FrPayeeCreateBuilder setPayeeAccount(FrPayeeAccount payeeAccount) {
        this.payeeAccount = payeeAccount;
        return this;
    }

    public String getLastName() {
        return this.lastName;
    }

    public FrPayeeCreateBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public FrPayeeCreateBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public FrPayeeCreateBuilder setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }
}

