/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.fastremittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class FrCreateQuotationBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String originalCurrency;
    private String originalAmount;
    private String targetCurrency;
    private String targetAmount;
    private String payerType;
    private String payeeType;
    private String quotationType;
    private String payeeOrgCode;
    private String payeeOrgCountry;
    private String payeeBankNo;
    private String tenor;
    private String includeFee;
    private String partnerCommissionFeeType;
    private String partnerCommissionFeeValue;
    private String payeeRequestId;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    public FrCreateQuotationBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public FrCreateQuotationBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public FrCreateQuotationBuilder setOriginalCurrency(String originalCurrency) {
        this.originalCurrency = originalCurrency;
        return this;
    }

    public FrCreateQuotationBuilder setOriginalAmount(String originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    public FrCreateQuotationBuilder setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
        return this;
    }

    public FrCreateQuotationBuilder setTargetAmount(String targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    public FrCreateQuotationBuilder setPayerType(String payerType) {
        this.payerType = payerType;
        return this;
    }

    public FrCreateQuotationBuilder setPayeeType(String payeeType) {
        this.payeeType = payeeType;
        return this;
    }

    public FrCreateQuotationBuilder setQuotationType(String quotationType) {
        this.quotationType = quotationType;
        return this;
    }

    public FrCreateQuotationBuilder setPayeeOrgCode(String payeeOrgCode) {
        this.payeeOrgCode = payeeOrgCode;
        return this;
    }

    public FrCreateQuotationBuilder setPayeeOrgCountry(String payeeOrgCountry) {
        this.payeeOrgCountry = payeeOrgCountry;
        return this;
    }

    public FrCreateQuotationBuilder setPayeeBankNo(String payeeBankNo) {
        this.payeeBankNo = payeeBankNo;
        return this;
    }

    public FrCreateQuotationBuilder setTenor(String tenor) {
        this.tenor = tenor;
        return this;
    }

    public FrCreateQuotationBuilder setIncludeFee(String includeFee) {
        this.includeFee = includeFee;
        return this;
    }

    public FrCreateQuotationBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public FrCreateQuotationBuilder setPartnerCommissionFeeType(String partnerCommissionFeeType) {
        this.partnerCommissionFeeType = partnerCommissionFeeType;
        return this;
    }

    public FrCreateQuotationBuilder setPartnerCommissionFeeValue(String partnerCommissionFeeValue) {
        this.partnerCommissionFeeValue = partnerCommissionFeeValue;
        return this;
    }

    public FrCreateQuotationBuilder setPayeeRequestId(String payeeRequestId) {
        this.payeeRequestId = payeeRequestId;
        return this;
    }
}

