/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.cp.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class RefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String refundAmount;
    private String orderId;
    private String remark;
    private String notifyUrl;

    public RefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RefundBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public RefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RefundBuilder setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
        return this;
    }

    public RefundBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public RefundBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

