/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.cp.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.builder.BuilderSupport;
import com.ehking.sdk.cp.entity.HotelInfo;
import com.ehking.sdk.cp.entity.OtherInfo;
import com.ehking.sdk.cp.entity.ProductDetail;
import com.ehking.sdk.cp.entity.StudyAbroadInfo;
import com.ehking.sdk.cp.entity.TicketInfo;
import com.ehking.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String settlementCurrency;
    private Long orderAmount;
    private String orderCurrency;
    private String notifyUrl;
    private String callbackUrl;
    private String isDirect;
    private String subject;
    private String paymentModeCode;
    private String clientIp;
    private String authCode;
    private String openId;
    private String appId;
    private String forUse;
    private String remark;
    private String merchantCreateTs;
    private String studentIdType;
    private String studentIdNo;
    private String studentPhoneNo;
    private String studentEmail;
    private String payerIdType;
    private String payerIdNo;
    private String payerName;
    private String payerNameZh;
    private String payerPhoneNo;
    private String payerFirstName;
    private String payerLastName;
    private String payerEmail;
    private String payerStudentRelation;
    private String walletRegion;
    private HotelInfo hotelInfo;
    private TicketInfo ticketInfo;
    private StudyAbroadInfo studyAbroadInfo;
    private OtherInfo otherInfo;
    private List<ProductDetail> goodstrades = new LinkedList<ProductDetail>();
    private String timeout;
    private String gatewayType;

    public OrderBuilder setGatewayType(String gatewayType) {
        this.gatewayType = gatewayType;
        return this;
    }

    public OrderBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public OrderBuilder setForUse(String forUse) {
        this.forUse = forUse;
        return this;
    }

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(Long orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setMerchantCreateTs(String merchantCreateTs) {
        this.merchantCreateTs = merchantCreateTs;
        return this;
    }

    public OrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public OrderBuilder setAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public OrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.goodstrades.add(productDetail);
        return this;
    }

    public OrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public OrderBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public OrderBuilder setSettlementCurrency(String settlementCurrency) {
        this.settlementCurrency = settlementCurrency;
        return this;
    }

    public OrderBuilder setIsDirect(String isDirect) {
        this.isDirect = isDirect;
        return this;
    }

    public OrderBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public OrderBuilder setStudentIdType(String studentIdType) {
        this.studentIdType = studentIdType;
        return this;
    }

    public OrderBuilder setStudentIdNo(String studentIdNo) {
        this.studentIdNo = studentIdNo;
        return this;
    }

    public OrderBuilder setStudentPhoneNo(String studentPhoneNo) {
        this.studentPhoneNo = studentPhoneNo;
        return this;
    }

    public OrderBuilder setStudentEmail(String studentEmail) {
        this.studentEmail = studentEmail;
        return this;
    }

    public OrderBuilder setPayerIdType(String payerIdType) {
        this.payerIdType = payerIdType;
        return this;
    }

    public OrderBuilder setPayerIdNo(String payerIdNo) {
        this.payerIdNo = payerIdNo;
        return this;
    }

    public OrderBuilder setPayerName(String payerName) {
        this.payerName = payerName;
        return this;
    }

    public OrderBuilder setPayerNameZh(String payerNameZh) {
        this.payerNameZh = payerNameZh;
        return this;
    }

    public OrderBuilder setPayerPhoneNo(String payerPhoneNo) {
        this.payerPhoneNo = payerPhoneNo;
        return this;
    }

    public OrderBuilder setPayerFirstName(String payerFirstName) {
        this.payerFirstName = payerFirstName;
        return this;
    }

    public OrderBuilder setPayerLastName(String payerLastName) {
        this.payerLastName = payerLastName;
        return this;
    }

    public OrderBuilder setPayerStudentRelation(String payerStudentRelation) {
        this.payerStudentRelation = payerStudentRelation;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public void setHotelInfo(HotelInfo hotelInfo) {
        this.hotelInfo = hotelInfo;
    }

    public void setTicketInfo(TicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
    }

    public void setStudyAbroadInfo(StudyAbroadInfo studyAbroadInfo) {
        this.studyAbroadInfo = studyAbroadInfo;
    }

    public void setOtherInfo(OtherInfo otherInfo) {
        this.otherInfo = otherInfo;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSettlementCurrency() {
        return this.settlementCurrency;
    }

    public Long getOrderAmount() {
        return this.orderAmount;
    }

    public String getOrderCurrency() {
        return this.orderCurrency;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getIsDirect() {
        return this.isDirect;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPaymentModeCode() {
        return this.paymentModeCode;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getForUse() {
        return this.forUse;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getMerchantCreateTs() {
        return this.merchantCreateTs;
    }

    public String getStudentIdType() {
        return this.studentIdType;
    }

    public String getStudentIdNo() {
        return this.studentIdNo;
    }

    public String getStudentPhoneNo() {
        return this.studentPhoneNo;
    }

    public String getStudentEmail() {
        return this.studentEmail;
    }

    public String getPayerIdType() {
        return this.payerIdType;
    }

    public String getPayerIdNo() {
        return this.payerIdNo;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public String getPayerNameZh() {
        return this.payerNameZh;
    }

    public String getPayerPhoneNo() {
        return this.payerPhoneNo;
    }

    public String getPayerFirstName() {
        return this.payerFirstName;
    }

    public String getPayerLastName() {
        return this.payerLastName;
    }

    public String getPayerStudentRelation() {
        return this.payerStudentRelation;
    }

    public HotelInfo getHotelInfo() {
        return this.hotelInfo;
    }

    public TicketInfo getTicketInfo() {
        return this.ticketInfo;
    }

    public StudyAbroadInfo getStudyAbroadInfo() {
        return this.studyAbroadInfo;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }

    public List<ProductDetail> getGoodstrades() {
        return this.goodstrades;
    }

    public void setGoodstrades(List<ProductDetail> goodstrades) {
        this.goodstrades = goodstrades;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getGatewayType() {
        return this.gatewayType;
    }

    public String getWalletRegion() {
        return this.walletRegion;
    }

    public OrderBuilder setWalletRegion(String walletRegion) {
        this.walletRegion = walletRegion;
        return this;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public OrderBuilder setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
        return this;
    }
}

