/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.auth.utils;

import com.ehking.sdk.auth.reader.PathAuthCertificateReader;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWSUtils {
    private static final Logger logger = LoggerFactory.getLogger(JWSUtils.class);
    private static PathAuthCertificateReader pathAuthCertificateReader;

    public static String encryption(String customData, String merchantId) throws Exception {
        RSAPrivateKey amzPrivateKey = JWSUtils.readPrivateKey(pathAuthCertificateReader.readPrivateKey(merchantId));
        RSAPublicKey gsPublicKey = JWSUtils.readPublicKey(pathAuthCertificateReader.readContentPublicKey());
        String jwe = JWSUtils.createJwe(customData, gsPublicKey);
        logger.info("generated JWE:{} ", (Object)jwe);
        String jws = JWSUtils.createJwsWithJwe(jwe, amzPrivateKey);
        logger.info("generated JWS:{} ", (Object)jws);
        return jws;
    }

    public static String decrypt(String message, String merchantId) throws Exception {
        RSAPrivateKey amzPrivateKey = JWSUtils.readPrivateKey(pathAuthCertificateReader.readPrivateKey(merchantId));
        RSAPublicKey gsPublicKey = JWSUtils.readPublicKey(pathAuthCertificateReader.readSignPublicKey());
        JWSObject jwsObject = JWSObject.parse((String)message);
        RSASSAVerifier verifier = new RSASSAVerifier(gsPublicKey);
        boolean isJwsValid = jwsObject.verify((JWSVerifier)verifier);
        logger.info("JWS valid:{}", (Object)isJwsValid);
        JWEObject jweObject = JWSUtils.decryptJwe(jwsObject.getPayload().toString(), amzPrivateKey);
        logger.info("decrypted data:{} ", (Object)jweObject.getPayload());
        return jweObject.getPayload().toString();
    }

    private static String createJwsWithJwe(String jwe, RSAPrivateKey privateKey) throws JOSEException {
        RSASSASigner signer = new RSASSASigner((PrivateKey)privateKey);
        JWSObject jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.PS512).contentType("JWT").build(), new Payload(jwe));
        jwsObject.sign((JWSSigner)signer);
        return jwsObject.serialize();
    }

    private static boolean verifyJws(String jws, RSAPublicKey publicKey) throws ParseException, JOSEException {
        JWSObject jwsObject = JWSObject.parse((String)jws);
        RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
        return jwsObject.verify((JWSVerifier)verifier);
    }

    private static String createJwe(String payloadData, RSAPublicKey publicKey) throws JOSEException {
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A256GCM).build(), new Payload(payloadData));
        jweObject.encrypt((JWEEncrypter)new RSAEncrypter(publicKey));
        return jweObject.serialize();
    }

    private static JWEObject decryptJwe(String jwe, RSAPrivateKey privateKey) throws ParseException, JOSEException {
        JWEObject jweObject = JWEObject.parse((String)jwe);
        jweObject.decrypt((JWEDecrypter)new RSADecrypter((PrivateKey)privateKey));
        return jweObject;
    }

    private static KeyPair generateRsaKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(3072);
        return keyPairGenerator.generateKeyPair();
    }

    public static RSAPrivateKey readPrivateKey(String key) throws Exception {
        char[] pwd = new char[]{'\u0001'};
        return JWSUtils.loadCertificateString(key, pwd);
    }

    public static RSAPublicKey readPublicKey(String ruleKey) throws Exception {
        RSAPublicKey rsaPublicKey = null;
        rsaPublicKey = (RSAPublicKey)JWSUtils.getPublicKeyFromString(ruleKey);
        return rsaPublicKey;
    }

    private static RSAPrivateKey loadCertificateString(String keyText, char[] password) throws Exception {
        byte[] decoded = Base64.getDecoder().decode(keyText);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decoded));
    }

    private static PublicKey getPublicKeyFromString(String key) throws Exception {
        String publicKeyPEM = key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        byte[] decoded = Base64.getDecoder().decode(publicKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new X509EncodedKeySpec(decoded));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        pathAuthCertificateReader = new PathAuthCertificateReader();
    }
}

