/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.auth.reader;

import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.reader.PathCertificateReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathAuthCertificateReader {
    static final Logger LOGGER = LoggerFactory.getLogger(PathCertificateReader.class);
    private Base64 base64 = new Base64();
    private String serverSignPublicKey;
    private String serverContentPublicKey;
    static final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readPrivateKey(String merchantId) throws Exception {
        if (cache.containsKey(merchantId)) {
            return cache.get(merchantId);
        }
        this.lock.lock();
        try {
            if (cache.containsKey(merchantId)) {
                String string = cache.get(merchantId);
                return string;
            }
            String keyPath = ConfigurationUtils.getClientPrivateKeyPath(merchantId);
            if (StringUtils.isBlank((CharSequence)keyPath)) {
                throw new IllegalArgumentException("no private key configuration , merchantId:[" + merchantId + "]");
            }
            String password = ConfigurationUtils.getClientPrivateKeyPassword(merchantId);
            char[] pwd = this.getPasswordChars(password);
            String privateKeyStr = this.loadCertificateString(keyPath, pwd);
            cache.put(merchantId, privateKeyStr);
            String string = privateKeyStr;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String readSignPublicKey() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.serverSignPublicKey)) {
            return this.serverSignPublicKey;
        }
        this.lock.lock();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.serverSignPublicKey)) {
                String string = this.serverSignPublicKey;
                return string;
            }
            String path = ConfigurationUtils.getAuthServerSignPublicKey();
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new IllegalArgumentException("auth no server sign public key configuration");
            }
            this.serverSignPublicKey = new String(this.base64.encode(this.parsePublicKey(path).getPublicKey().getEncoded()));
        }
        finally {
            this.lock.unlock();
        }
        return this.serverSignPublicKey;
    }

    public String readContentPublicKey() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.serverContentPublicKey)) {
            return this.serverContentPublicKey;
        }
        this.lock.lock();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.serverContentPublicKey)) {
                String string = this.serverContentPublicKey;
                return string;
            }
            String path = ConfigurationUtils.getAuthServerContentPublicKey();
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new IllegalArgumentException("auth no server content public key configuration");
            }
            this.serverContentPublicKey = new String(this.base64.encode(this.parsePublicKey(path).getPublicKey().getEncoded()));
        }
        finally {
            this.lock.unlock();
        }
        return this.serverContentPublicKey;
    }

    public X509Certificate parsePublicKey(String path) throws Exception {
        X509Certificate x509Certificate = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("not found server public key file in the absolute path , try the relative path , keyPath:[" + path + "]");
        }
        if (null == fileInputStream) {
            fileInputStream = this.getClass().getResourceAsStream(path);
        }
        if (null == fileInputStream) {
            throw new IllegalArgumentException("not found server public key file, keyPath:[" + path + "]");
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (x509Certificate != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return x509Certificate;
    }

    private KeyStore loadCertificate(String keyPath, char[] password) throws Exception {
        KeyStore ks;
        InputStream fis = null;
        if (StringUtils.isBlank((CharSequence)keyPath)) {
            throw new IllegalArgumentException("no private key configuration , keyPath:[" + keyPath + "]");
        }
        try {
            fis = new FileInputStream(keyPath);
        }
        catch (Exception e) {
            LOGGER.warn("not found private key file in the absolute path , try the relative path , keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        if (null == fis) {
            fis = this.getClass().getResourceAsStream(keyPath);
        }
        if (null == fis) {
            throw new IllegalArgumentException("not found private key file, keyPath:[" + keyPath + "] keyPath:[" + keyPath + "]");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(fis, password);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ks;
    }

    private String loadCertificateString(String keyPath, char[] password) throws Exception {
        KeyStore ks = this.loadCertificate(keyPath, password);
        Enumeration<String> enumas = ks.aliases();
        String keyAlias = null;
        if (enumas.hasMoreElements()) {
            keyAlias = enumas.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, password);
        return new String(this.base64.encode(privateKey.getEncoded()));
    }

    private char[] getPasswordChars(String password) {
        return StringUtils.isNotBlank((CharSequence)password) ? password.toCharArray() : null;
    }
}

