/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.auth.executer;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.auth.utils.JWSUtils;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(AuthQueryExecuter.class);

    public void bothQuery(String requestId, String merchantId, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("AuthQueryExecuter queryV_3 requestId : {}", (Object)requestId);
            String responseData = this.get(requestId, merchantId);
            LOGGER.info("AuthQueryExecuter queryV_3 response : {}", (Object)responseData);
            this.bothCipherCallback(responseData, listener, merchantId);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(String responseData, ResultListener listener, String merchantId) throws Exception {
        if (listener == null) {
            throw new NullPointerException();
        }
        String decrypt = JWSUtils.decrypt(responseData, merchantId);
        listener.success(JSONObject.parseObject((String)decrypt));
    }

    private String get(String requestId, String merchantId) {
        HttpGet httpGet = new HttpGet(ConfigurationUtils.getOrzAuthQueryUrl() + "/" + requestId);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("clientId", merchantId);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(50000).build();
        httpGet.setConfig(config);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            LOGGER.info("httpGet result={}", (Object)result);
            String string = result;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("httpGet error", (Throwable)e);
            throw new UnknownException(e);
        }
        finally {
            try {
                if (Objects.nonNull(httpClient)) {
                    httpClient.close();
                }
                if (Objects.nonNull(response)) {
                    response.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("httpClient.close error.", (Throwable)e);
            }
        }
    }
}

