/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.auth.executer;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.auth.builder.AuthOrderBuilder;
import com.ehking.sdk.auth.utils.JWSUtils;
import com.ehking.sdk.exception.UnknownException;
import com.ehking.sdk.executer.Executer;
import com.ehking.sdk.executer.ResultListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(AuthOrderExecuter.class);
    protected static final String CHARSET = "UTF-8";
    protected static final String CONTENT_ENCODING_ZIP = "gzip";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";

    public void order(AuthOrderBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            String jws = builder.bothEncryptBuild();
            LOGGER.info("AuthOrderExecuter orderV_3 jws : {}", (Object)jws);
            String responseBody = AuthOrderExecuter.post3(ConfigurationUtils.getOrzAuthOrderUrl(), jws, builder.getMerchantId());
            LOGGER.info("AuthOrderExecuter orderV_3 responseStr : {}", (Object)responseBody);
            this.bothCipherCallback(responseBody, listener, builder.getMerchantId());
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(String responseData, ResultListener listener, String merchantId) throws Exception {
        if (listener == null) {
            throw new NullPointerException();
        }
        String decrypt = JWSUtils.decrypt(responseData, merchantId);
        listener.success(JSONObject.parseObject((String)decrypt));
    }

    public static String post3(String urlStr, String jws, String merchantId) {
        StringBuilder sb;
        block9: {
            HttpURLConnection con = null;
            sb = new StringBuilder();
            int httpResult = 0;
            try {
                LOGGER.debug("data:[" + jws + "]");
                con = AuthOrderExecuter.createConnection(urlStr);
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("clientId", merchantId);
                String body = jws;
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(body.getBytes(CHARSET));
                wr.flush();
                wr.close();
                httpResult = con.getResponseCode();
                if (httpResult == 200) {
                    BufferedReader br = AuthOrderExecuter.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    br.close();
                    break block9;
                }
                if (httpResult == 406) {
                    throw new HttpResponseException(httpResult, "Data error, Access denied. Http status is 406 !");
                }
                throw new HttpResponseException(httpResult, con.getResponseMessage());
            }
            catch (Exception e) {
                LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        String responseBody = sb.toString();
        LOGGER.info("post3 responseBody : {}", (Object)responseBody);
        return responseBody;
    }

    private static HttpURLConnection createConnection(String urlStr) throws IOException {
        HttpURLConnection con = null;
        URL url = new URL(urlStr);
        con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", "SDK/2.0");
        con.setUseCaches(false);
        Integer connectTimeout = ConfigurationUtils.getConnectTimeout();
        if (connectTimeout != null) {
            con.setConnectTimeout(connectTimeout);
            LOGGER.info("set connectTimeout:[" + connectTimeout + "]");
        } else {
            LOGGER.info("not set connectTimeout:[" + connectTimeout + "]");
        }
        Integer readTimeout = ConfigurationUtils.getReadTimeout();
        if (readTimeout != null) {
            con.setReadTimeout(readTimeout);
            LOGGER.info("set readTimeout:[" + readTimeout + "]");
        } else {
            LOGGER.info("not set readTimeout:[" + connectTimeout + "]");
        }
        return con;
    }

    private static BufferedReader getBufferedReader(HttpURLConnection con) throws IOException {
        String headerEncoding = con.getHeaderField(HEADER_CONTENT_ENCODING);
        BufferedReader br = CONTENT_ENCODING_ZIP.equals(headerEncoding) ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(con.getInputStream()), CHARSET)) : new BufferedReader(new InputStreamReader(con.getInputStream(), CHARSET));
        return br;
    }
}

