/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.sdk.auth.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.sdk.CipherWrapper;
import com.ehking.sdk.ConfigurationUtils;
import com.ehking.sdk.RSAUtils;
import com.ehking.sdk.SignUtils;
import com.ehking.sdk.auth.utils.JWSUtils;
import com.ehking.sdk.auth.vo.VerifyRequestVO;
import com.ehking.sdk.builder.BuilderSupport;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthOrderBuilder
extends BuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(AuthOrderBuilder.class);
    private String merchantId;
    private String requestId;
    private String authType;
    private String name;
    private String idCardNum;
    private String bankCardNumber;
    private String phoneNumber;
    private String enterpriseName;
    private String enterpriseOriginCode;
    private String legalPersonName;
    private String legalPersonIdCardNo;
    private String enterpriseBankName;
    private String enterpriseBankAccount;

    public AuthOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public String bothEncryptBuild() throws Exception {
        String jsonString = JSONObject.toJSONString((Object)this.build());
        logger.info("bothEncryptBuild, jsonString:{}", (Object)jsonString);
        return JWSUtils.encryption(jsonString, this.merchantId);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdCardNum() {
        return this.idCardNum;
    }

    public void setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
    }

    public String getBankCardNumber() {
        return this.bankCardNumber;
    }

    public void setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getEnterpriseName() {
        return this.enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseOriginCode() {
        return this.enterpriseOriginCode;
    }

    public void setEnterpriseOriginCode(String enterpriseOriginCode) {
        this.enterpriseOriginCode = enterpriseOriginCode;
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public String getLegalPersonIdCardNo() {
        return this.legalPersonIdCardNo;
    }

    public void setLegalPersonIdCardNo(String legalPersonIdCardNo) {
        this.legalPersonIdCardNo = legalPersonIdCardNo;
    }

    public String getEnterpriseBankName() {
        return this.enterpriseBankName;
    }

    public void setEnterpriseBankName(String enterpriseBankName) {
        this.enterpriseBankName = enterpriseBankName;
    }

    public String getEnterpriseBankAccount() {
        return this.enterpriseBankAccount;
    }

    public void setEnterpriseBankAccount(String enterpriseBankAccount) {
        this.enterpriseBankAccount = enterpriseBankAccount;
    }

    public VerifyRequestVO build() {
        Object othrVO1;
        VerifyRequestVO verifyRequestVO = new VerifyRequestVO();
        VerifyRequestVO.VrfctnVO vrfctnVO = new VerifyRequestVO.VrfctnVO();
        vrfctnVO.setId(this.getRequestId());
        verifyRequestVO.setVrfctn(Collections.singletonList(vrfctnVO));
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO ptyAndAcctIdVO = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO pty = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO idVO1 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO();
        pty.setNm(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.enterpriseOriginCode)) {
            VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.OrgIdVO orgIdVO1 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.OrgIdVO();
            othrVO1 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.OrgIdVO.OthrVO();
            ((VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.OrgIdVO.OthrVO)othrVO1).setId(this.enterpriseOriginCode);
            orgIdVO1.setOthr(Collections.singletonList(othrVO1));
            idVO1.setOrgId(orgIdVO1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNum)) {
            VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.PrvtIdVO prvtIdVO = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.PrvtIdVO();
            othrVO1 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.PrvtIdVO.OthrVO();
            ((VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.PtyVO.IdVO.PrvtIdVO.OthrVO)othrVO1).setId(this.idCardNum);
            prvtIdVO.setOthr(Collections.singletonList(othrVO1));
            idVO1.setPrvtId(prvtIdVO);
        }
        pty.setId(idVO1);
        ptyAndAcctIdVO.setPty(pty);
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO acctVO = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.IdVO idVO2 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.IdVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.IdVO.OthrVO othrVO12 = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.IdVO.OthrVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.AgtVO agtVO = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.AgtVO();
        VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.AgtVO.BrnchIdVO brnchIdVO = new VerifyRequestVO.VrfctnVO.PtyAndAcctIdVO.AcctVO.AgtVO.BrnchIdVO();
        othrVO12.setId(this.bankCardNumber);
        if (StringUtils.isNotBlank((CharSequence)this.enterpriseOriginCode)) {
            brnchIdVO.setNm(this.enterpriseBankName);
        }
        agtVO.setBrnchId(brnchIdVO);
        ptyAndAcctIdVO.setAgt(agtVO);
        idVO2.setOthr(othrVO12);
        acctVO.setId(idVO2);
        ptyAndAcctIdVO.setAcct(acctVO);
        vrfctnVO.setPtyAndAcctId(ptyAndAcctIdVO);
        verifyRequestVO.setVrfctn(Collections.singletonList(vrfctnVO));
        return verifyRequestVO;
    }
}

